/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui;

import de.retest.persistence.StringInternerAdapter;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PathElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringInternerAdapter.class)
    private final String elementName;
    @XmlElement
    private final String suffix;

    public PathElement(String elementName, String suffix) {
        if (elementName == null) {
            throw new NullPointerException("Element name must not be null.");
        }
        this.elementName = elementName.trim();
        if (this.elementName.isEmpty()) {
            throw new IllegalArgumentException("Element name must not be empty.");
        }
        this.suffix = suffix.trim();
    }

    public PathElement(String elementName) {
        this(elementName, "");
    }

    public PathElement(String elementName, int suffix) {
        this(elementName, "" + suffix);
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        if ("".equals(this.suffix)) {
            return this.elementName;
        }
        return this.elementName + "[" + this.suffix + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement other = (PathElement)obj;
        if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }

    public static PathElement fromString(String path) {
        if (!path.contains("[")) {
            return new PathElement(path);
        }
        return new PathElement(path.substring(0, path.indexOf("[")), path.substring(path.indexOf("[") + 1, path.length() - 1));
    }
}

