/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium.css;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.web.selenium.css.Selector;
import de.retest.web.selenium.css.Transformer;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateBuilder {
    private static final Logger log = LoggerFactory.getLogger(PredicateBuilder.class);
    private final List<Transformer> selectors;
    private final List<Predicate<Element>> predicates;
    private final String origSelector;

    public PredicateBuilder(List<Transformer> selectors, String origSelector) {
        this.selectors = selectors;
        this.origSelector = origSelector;
        this.predicates = new LinkedList<Predicate<Element>>();
    }

    public Optional<Predicate<Element>> build() {
        String remainingSelector = this.parse(this.origSelector);
        if (this.isPartAvailable(remainingSelector)) {
            this.logUnkownSelector(remainingSelector);
            return Optional.empty();
        }
        return Optional.of(this.combinePredicates());
    }

    private String parse(String selector) {
        String oldSelector = "";
        String remainingSelector = selector;
        while (this.isPartAvailable(remainingSelector) && !oldSelector.equals(remainingSelector)) {
            oldSelector = remainingSelector;
            remainingSelector = this.transform(remainingSelector);
        }
        return remainingSelector;
    }

    private String transform(String selector) {
        String remainingSelector = selector;
        for (Transformer function : this.selectors) {
            Selector cssSelector = function.transform(remainingSelector);
            remainingSelector = cssSelector.getRemainingSelector();
            if (selector.equals(remainingSelector)) continue;
            this.predicates.add(cssSelector.getPredicate());
            return remainingSelector;
        }
        return remainingSelector;
    }

    private boolean isPartAvailable(String selector) {
        return !selector.isEmpty();
    }

    private void logUnkownSelector(String selector) {
        log.warn("Unbreakable tests are not implemented for all CSS selectors. Please report your chosen selector ('{}') at https://github.com/retest/recheck-web/issues.", (Object)selector);
    }

    private Predicate<Element> combinePredicates() {
        return this.predicates.stream().reduce(e -> true, Predicate::and);
    }
}

