/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.web.selenium.ByBestMatchToRetestId;
import de.retest.web.selenium.QualifiedElementWarning;
import de.retest.web.selenium.TestHealer;
import de.retest.web.selenium.WrappingWebElement;
import de.retest.web.util.SeleniumWrapperUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class UnbreakableDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities,
Interactive,
TakesScreenshot,
WrapsDriver {
    private final RemoteWebDriver wrappedDriver;
    private RootElement lastExpectedState;
    private RootElement lastActualState;
    private Consumer<QualifiedElementWarning> warningConsumer;

    public UnbreakableDriver(RemoteWebDriver wrappedDriver) {
        this.wrappedDriver = wrappedDriver;
    }

    public WebElement findElement(ByBestMatchToRetestId by) {
        Element searchedFor = by.findElement(this.lastExpectedState, this.lastActualState);
        WebElement element = this.wrappedDriver.findElement(By.xpath((String)searchedFor.getIdentifyingAttributes().getPath()));
        return this.wrap(element);
    }

    protected WebElement wrap(WebElement element) {
        return WrappingWebElement.wrap(this, element);
    }

    private List<WebElement> wrap(List<WebElement> elements) {
        return elements.stream().map(this::wrap).collect(Collectors.toList());
    }

    public WebElement findElementByRetestId(String retestId) {
        return this.findElement(new ByBestMatchToRetestId(retestId));
    }

    public WebElement findElement(By by) {
        if (by instanceof ByBestMatchToRetestId) {
            return this.findElement((ByBestMatchToRetestId)by);
        }
        try {
            return this.wrap(this.wrappedDriver.findElement(by));
        }
        catch (NoSuchElementException e) {
            WebElement matchedOld = TestHealer.findElement(by, this);
            if (matchedOld == null) {
                throw e;
            }
            return this.wrap(matchedOld);
        }
    }

    public List<WebElement> findElements(By by) {
        return this.wrap(this.wrappedDriver.findElements(by));
    }

    public WebElement findElementById(String using) {
        return this.wrap(this.wrappedDriver.findElementById(using));
    }

    public List<WebElement> findElementsById(String using) {
        return this.wrap(this.wrappedDriver.findElementsById(using));
    }

    public WebElement findElementByClassName(String using) {
        return this.wrap(this.wrappedDriver.findElementByClassName(using));
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.wrap(this.wrappedDriver.findElementsByClassName(using));
    }

    public WebElement findElementByLinkText(String using) {
        return this.wrap(this.wrappedDriver.findElementByLinkText(using));
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.wrap(this.wrappedDriver.findElementsByLinkText(using));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.wrap(this.wrappedDriver.findElementByPartialLinkText(using));
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.wrap(this.wrappedDriver.findElementsByPartialLinkText(using));
    }

    public WebElement findElementByName(String using) {
        return this.wrap(this.wrappedDriver.findElementByName(using));
    }

    public List<WebElement> findElementsByName(String using) {
        return this.wrap(this.wrappedDriver.findElementsByName(using));
    }

    public WebElement findElementByCssSelector(String using) {
        return this.wrap(this.wrappedDriver.findElementByCssSelector(using));
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.wrap(this.wrappedDriver.findElementsByCssSelector(using));
    }

    public WebElement findElementByTagName(String using) {
        return this.wrap(this.wrappedDriver.findElementByTagName(using));
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.wrap(this.wrappedDriver.findElementsByTagName(using));
    }

    public WebElement findElementByXPath(String using) {
        return this.wrap(this.wrappedDriver.findElementByXPath(using));
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.wrap(this.wrappedDriver.findElementsByXPath(using));
    }

    public void close() {
        this.wrappedDriver.close();
    }

    public void get(String url) {
        this.wrappedDriver.get(url);
    }

    public String getCurrentUrl() {
        return this.wrappedDriver.getCurrentUrl();
    }

    public String getPageSource() {
        return this.wrappedDriver.getPageSource();
    }

    public String getTitle() {
        return this.wrappedDriver.getTitle();
    }

    public String getWindowHandle() {
        return this.wrappedDriver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.wrappedDriver.getWindowHandles();
    }

    public WebDriver.Options manage() {
        return this.wrappedDriver.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.wrappedDriver.navigate();
    }

    public void quit() {
        this.wrappedDriver.quit();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.wrappedDriver.switchTo();
    }

    public Object executeScript(String script, Object ... args) {
        return this.wrappedDriver.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.wrappedDriver.executeAsyncScript(script, args);
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        return (X)this.wrappedDriver.getScreenshotAs(target);
    }

    public Keyboard getKeyboard() {
        return this.wrappedDriver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.wrappedDriver.getMouse();
    }

    public Capabilities getCapabilities() {
        return this.wrappedDriver.getCapabilities();
    }

    public void perform(Collection<Sequence> actions) {
        this.wrappedDriver.perform(actions);
    }

    public void resetInputState() {
        this.wrappedDriver.resetInputState();
    }

    public WebDriver getWrappedDriver() {
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, this.wrappedDriver)) {
            return SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, this.wrappedDriver);
        }
        return this.wrappedDriver;
    }

    public WebDriver skipCheck() {
        return this.getWrappedDriver();
    }

    public RootElement getLastExpectedState() {
        return this.lastExpectedState;
    }

    public RootElement getLastActualState() {
        return this.lastActualState;
    }

    public Consumer<QualifiedElementWarning> getWarningConsumer() {
        return this.warningConsumer;
    }

    public void setLastExpectedState(RootElement lastExpectedState) {
        this.lastExpectedState = lastExpectedState;
    }

    public void setLastActualState(RootElement lastActualState) {
        this.lastActualState = lastActualState;
    }

    public void setWarningConsumer(Consumer<QualifiedElementWarning> warningConsumer) {
        this.warningConsumer = warningConsumer;
    }
}

