/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.diff.Alignment;
import de.retest.web.selenium.ByBestMatchToRetestId;
import de.retest.web.selenium.NoElementWithHighEnoughMatchFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public abstract class By
extends org.openqa.selenium.By {
    public static ByBestMatchToRetestId retestId(String retestId) {
        return new ByBestMatchToRetestId(retestId);
    }

    public static Element findElement(RootElement lastExpectedState, RootElement lastActualState, Predicate<Element> predicate) {
        if (lastExpectedState == null) {
            throw new IllegalArgumentException("Cannot find element in null state.");
        }
        Element resultFromExpected = By.findElement(lastExpectedState.getContainedElements(), predicate);
        if (resultFromExpected == null) {
            return null;
        }
        Alignment alignment = Alignment.createAlignment((Element)lastExpectedState, (Element)lastActualState);
        Element resultFromActual = alignment.getActual(resultFromExpected);
        if (resultFromActual == null) {
            throw new NoElementWithHighEnoughMatchFoundException(resultFromExpected);
        }
        return resultFromActual.applyRetestId(resultFromExpected.getRetestId());
    }

    public static Element findElement(List<Element> children, Predicate<Element> predicate) {
        for (Element element : children) {
            if (predicate.test(element)) {
                return element;
            }
            Element result = By.findElement(element.getContainedElements(), predicate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<Element> findElements(List<Element> children, Predicate<Element> predicate) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : children) {
            if (predicate.test(element)) {
                result.add(element);
            }
            result.addAll(By.findElements(element.getContainedElements(), predicate));
        }
        return result;
    }

    public static Element findElementByAttribute(RootElement lastExpectedState, RootElement lastActualState, String attributeName, Predicate<Object> condition) {
        return By.findElement(lastExpectedState, lastActualState, element -> {
            if (element.getIdentifyingAttributes().get(attributeName) != null) {
                return condition.test(element.getIdentifyingAttributes().getAttribute(attributeName).getValue());
            }
            if (element.getAttributes().get(attributeName) != null) {
                return condition.test(element.getAttributes().get(attributeName));
            }
            return false;
        });
    }

    public static Element findElementByAttribute(RootElement lastExpectedState, RootElement lastActualState, String attributeName, Object attributeValue) {
        return By.findElementByAttribute(lastExpectedState, lastActualState, attributeName, attributeValue::equals);
    }
}

