/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.retest.web.selenium.AutocheckingCheckNamingStrategy;
import java.util.Arrays;
import org.openqa.selenium.WebElement;

public class ActionbasedCheckNamingStrategy
implements AutocheckingCheckNamingStrategy {
    private static final int MAX_TEXT_INPUT_LENGTH = 10;
    private final Multiset<String> checks = HashMultiset.create();

    @Override
    public String getUniqueCheckName(String action, WebElement targetElement, Object ... params) {
        String result = action;
        if ("enter".equals(action)) {
            result = params instanceof CharSequence[] ? "enter_" + this.shortenTextInput((CharSequence[])params) + "_into" : "enter_nothing_into";
        }
        if ("get".equals(action) && params.length > 0) {
            result = "get_[" + this.shortenUrl(params[0]) + "]";
        }
        if (targetElement != null) {
            result = result + "_" + this.toString(targetElement);
        }
        return this.makeUnique(result);
    }

    @Override
    public String getUniqueCheckName(String action) {
        return this.makeUnique(action);
    }

    protected String makeUnique(String result) {
        this.checks.add((Object)result);
        if (this.checks.count((Object)result) == 1) {
            return result;
        }
        return result + "_" + this.checks.count((Object)result);
    }

    protected String toString(WebElement targetElement) {
        String result = targetElement.toString();
        if (result.contains("->")) {
            result = result.substring(result.lastIndexOf("->") + 2).trim();
            result = result.substring(0, result.length() - 1);
            result = result.substring(result.lastIndexOf(58) + 1).trim();
        }
        return result;
    }

    protected String shortenTextInput(CharSequence[] keysToSend) {
        if (keysToSend == null || keysToSend.length == 0) {
            return "";
        }
        String stringToSend = Arrays.toString(keysToSend);
        if (stringToSend.length() <= 10) {
            return stringToSend;
        }
        String suffix = "...]";
        return stringToSend.substring(0, 10 - "...]".length()) + "...]";
    }

    protected String shortenUrl(Object url) {
        if (url == null) {
            return "";
        }
        return url.toString().replace("http://", "").replace("https://", "");
    }

    @Override
    public void nextTest() {
        this.checks.clear();
    }
}

