/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.screenshot;

import de.retest.recheck.ui.image.ImageUtils;
import de.retest.web.RecheckWebOptions;
import de.retest.web.screenshot.FullPageScreenshot;
import de.retest.web.screenshot.NoScreenshot;
import de.retest.web.screenshot.ScreenshotProvider;
import de.retest.web.screenshot.ViewportOnlyMinimalScreenshot;
import de.retest.web.screenshot.ViewportOnlyScreenshot;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import org.aeonbits.owner.Converter;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotProviders {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotProviders.class);
    public static final ScreenshotProvider DEFAULT = new ViewportOnlyMinimalScreenshot();
    public static final ScreenshotProvider NONE = new NoScreenshot();
    public static final int SCALE = ImageUtils.extractScale();

    private ScreenshotProviders() {
    }

    public static BufferedImage shoot(WebDriver driver, WebElement element, ScreenshotProvider screenshotProvider) {
        try {
            long startTime = System.currentTimeMillis();
            if (element != null) {
                return screenshotProvider.shoot(driver, element);
            }
            BufferedImage result = screenshotProvider.shoot(driver);
            log.info("Took {}ms to create the screenshot.", (Object)(System.currentTimeMillis() - startTime));
            return result;
        }
        catch (Exception e) {
            log.error("Exception creating screenshot for check.", (Throwable)e);
            return null;
        }
    }

    public static class ScreenshotProviderConverter
    implements Converter<ScreenshotProvider> {
        public ScreenshotProvider convert(Method method, String input) {
            switch (input) {
                case "fullPage": {
                    return new FullPageScreenshot();
                }
                case "viewportOnly": {
                    return new ViewportOnlyScreenshot();
                }
                case "viewportOnlyMinimal": {
                    return new ViewportOnlyMinimalScreenshot();
                }
                case "none": {
                    log.info("ScreenshotProvider has been set to 'none' either via property de.retest.recheck.web.screenshot.provider or via " + RecheckWebOptions.class.getSimpleName() + ", will create NO screenshots.");
                    return NONE;
                }
            }
            log.warn("Unknown configured screenshot provider '{}'. Using default value 'viewportOnlyMinimal'.", (Object)input);
            return DEFAULT;
        }
    }
}

