/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.meta.driver.capabilities;

import de.retest.recheck.meta.MetadataProvider;
import de.retest.recheck.meta.MultiMetadataProvider;
import de.retest.web.meta.driver.capabilities.BrowserMetadataProvider;
import de.retest.web.meta.driver.capabilities.PlatformMetadataProvider;
import de.retest.web.util.SeleniumWrapperUtil;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CapabilityMetadataProvider
implements MetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(CapabilityMetadataProvider.class);
    private final MetadataProvider provider;

    CapabilityMetadataProvider(Capabilities capabilities) {
        this.provider = MultiMetadataProvider.of((MetadataProvider[])new MetadataProvider[]{new BrowserMetadataProvider(capabilities), new PlatformMetadataProvider(capabilities)});
    }

    public static MetadataProvider of(WebDriver driver) {
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, driver)) {
            return CapabilityMetadataProvider.of(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, driver));
        }
        if (driver instanceof RemoteWebDriver) {
            return CapabilityMetadataProvider.of((RemoteWebDriver)driver);
        }
        log.debug("Cannot retrieve capabilities from driver {}. Driver must be of '{}'. Returning empty metadata.", (Object)driver, RemoteWebDriver.class);
        return MetadataProvider.empty();
    }

    public static CapabilityMetadataProvider of(RemoteWebDriver driver) {
        return CapabilityMetadataProvider.of(driver.getCapabilities());
    }

    private static CapabilityMetadataProvider of(Capabilities capabilities) {
        return new CapabilityMetadataProvider(capabilities);
    }

    public Map<String, String> retrieve() {
        return this.provider.retrieve();
    }
}

