/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.meta;

import de.retest.recheck.meta.MetadataProvider;
import de.retest.recheck.meta.MultiMetadataProvider;
import de.retest.web.meta.driver.WebDriverMetadataProvider;
import de.retest.web.meta.element.WebElementMetadataProvider;
import de.retest.web.util.SeleniumWrapperUtil;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class SeleniumMetadataProvider
implements MetadataProvider {
    public static final String TYPE_DRIVER = "driver";
    public static final String TYPE_ELEMENT = "element";
    private final String type;

    public static MetadataProvider of(Object object) {
        if (object instanceof WebElement) {
            return SeleniumMetadataProvider.of((WebElement)object);
        }
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.ELEMENT, object)) {
            return SeleniumMetadataProvider.of(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.ELEMENT, object));
        }
        if (object instanceof WebDriver) {
            return SeleniumMetadataProvider.of((WebDriver)object);
        }
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, object)) {
            return SeleniumMetadataProvider.of(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, object));
        }
        throw new IllegalArgumentException(String.format("Cannot retrieve metadata from objects of type '%s'.", object.getClass().getName()));
    }

    private static MetadataProvider of(WebDriver object) {
        return MultiMetadataProvider.of((MetadataProvider[])new MetadataProvider[]{WebDriverMetadataProvider.of(object), new SeleniumMetadataProvider(TYPE_DRIVER)});
    }

    private static MetadataProvider of(WebElement object) {
        return MultiMetadataProvider.of((MetadataProvider[])new MetadataProvider[]{WebElementMetadataProvider.of(object), new SeleniumMetadataProvider(TYPE_ELEMENT)});
    }

    public Map<String, String> retrieve() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("check.type", this.type);
        return map;
    }

    SeleniumMetadataProvider(String type) {
        this.type = type;
    }
}

