/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.MutableAttributes;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.web.WebElementPeer;
import de.retest.web.mapping.WebData;
import java.awt.image.BufferedImage;

public class RootElementPeer
extends WebElementPeer {
    private final String title;
    private final BufferedImage screenshot;

    public RootElementPeer(RetestIdProvider retestIdProvider, WebData webData, String path, String title, BufferedImage screenshot, DefaultValueFinder defaultValueFinder) {
        super(retestIdProvider, webData, path, defaultValueFinder);
        this.screenshot = screenshot;
        this.title = title;
    }

    public RootElement toElement(Element parent) {
        if (this.webData == null) {
            throw new IllegalStateException("RootElement was not properly initialized!");
        }
        IdentifyingAttributes identifyingAttributes = this.retrieveIdentifyingAttributes();
        String screen = this.title;
        String title = this.title;
        if (!identifyingAttributes.getType().equals("html")) {
            screen = "WebElement";
            title = identifyingAttributes.getPath();
        }
        MutableAttributes stateAttributes = this.retrieveStateAttributes(identifyingAttributes);
        String retestId = this.retestIdProvider.getRetestId(identifyingAttributes);
        Screenshot ss = ImageUtils.image2Screenshot((String)retestId, (BufferedImage)this.screenshot);
        RootElement rootElement = new RootElement(retestId, identifyingAttributes, stateAttributes.immutable(), ss, screen, 1, title);
        rootElement.addChildren(this.convertChildren((Element)rootElement));
        return rootElement;
    }
}

