/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.web.RootElementPeer;
import de.retest.web.WebElementPeer;
import de.retest.web.mapping.PathsToWebDataMapping;
import de.retest.web.mapping.WebData;
import de.retest.web.mapping.WebDataFilter;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

class PeerConverter {
    private final Map<String, WebElementPeer> converted = new HashMap<String, WebElementPeer>();
    private final RetestIdProvider retestIdProvider;
    private final PathsToWebDataMapping mapping;
    private final String title;
    private final BufferedImage screenshot;
    private final DefaultValueFinder defaultValueFinder;
    private final String rootParentPath;
    private RootElementPeer root = null;

    public PeerConverter(RetestIdProvider retestIdProvider, PathsToWebDataMapping mapping, String title, BufferedImage screenshot, DefaultValueFinder defaultValueFinder, String rootPath) {
        this.retestIdProvider = retestIdProvider;
        this.mapping = mapping;
        this.title = title;
        this.screenshot = screenshot;
        this.defaultValueFinder = defaultValueFinder;
        this.rootParentPath = this.getRootParentPath(rootPath);
    }

    protected String getRootParentPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        return rootPath.substring(0, rootPath.lastIndexOf("/"));
    }

    public RootElement convertToPeers() {
        this.retestIdProvider.reset();
        for (Map.Entry<String, WebData> entry : this.mapping) {
            String path = entry.getKey();
            WebData webData = entry.getValue();
            if (!this.isRoot(PeerConverter.getParentPath(path)) && WebDataFilter.shouldIgnore(webData)) continue;
            this.convertToPeer(path, webData);
        }
        if (this.root == null) {
            throw new NullPointerException("RootElementPeer is null.");
        }
        return this.root.toElement(null);
    }

    private WebElementPeer convertToPeer(String path, WebData webData) {
        String parentPath = PeerConverter.getParentPath(path);
        WebElementPeer peer = this.converted.get(path);
        if (peer != null) {
            return peer;
        }
        if (this.isRoot(parentPath)) {
            assert (this.root == null) : "We can only have one root element!";
            this.root = new RootElementPeer(this.retestIdProvider, webData, path, this.title, this.screenshot, this.defaultValueFinder);
            peer = this.root;
        } else {
            peer = new WebElementPeer(this.retestIdProvider, webData, path, this.defaultValueFinder);
            WebElementPeer parent = this.converted.get(parentPath);
            if (parent == null) {
                parent = this.convertToPeer(parentPath, this.mapping.getWebData(parentPath));
            }
            parent.addChild(peer);
        }
        this.converted.put(path, peer);
        return peer;
    }

    protected boolean isRoot(String parentPath) {
        return parentPath == null || parentPath.equals(this.rootParentPath);
    }

    static String getParentPath(String path) {
        if (!path.contains("/")) {
            return null;
        }
        String parentPath = path.substring(0, path.lastIndexOf(47));
        if (parentPath.length() == 1) {
            return null;
        }
        return parentPath;
    }
}

