/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.web.PeerConverter;
import de.retest.web.mapping.PathsToWebDataMapping;
import de.retest.web.mapping.WebData;
import de.retest.web.selenium.By;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameConverter {
    private static final Logger log = LoggerFactory.getLogger(FrameConverter.class);
    private final String queryJs;
    private final RetestIdProvider retestIdProvider;
    private final DefaultValueFinder defaultValueFinder;
    private final String parentFramePrefix;

    public FrameConverter(String queryJs, RetestIdProvider retestIdProvider, DefaultValueFinder defaultValueFinder) {
        this(queryJs, retestIdProvider, defaultValueFinder, "");
    }

    public void addChildrenFromFrames(WebDriver driver, RootElement lastChecked) {
        List<Element> frames = By.findElements(lastChecked.getContainedElements(), FrameConverter.isFrame());
        if (frames.size() <= 0) {
            log.debug("Found no sub-frames.");
            return;
        }
        log.debug("Found {} sub-frame(s), getting data per frame.", (Object)frames.size());
        for (Element frame : frames) {
            this.addChildrenFromFrame(driver, frame);
            driver.switchTo().defaultContent();
        }
    }

    private void addChildrenFromFrame(WebDriver driver, Element frame) {
        try {
            WebElement frameWebElement = this.getFrameParent(driver, frame);
            log.debug("Switching to frame '{}'.", (Object)frame);
            driver.switchTo().frame(frameWebElement);
            log.debug("Retrieving data content of frame '{}'.", (Object)frame);
            String framePath = frame.getIdentifyingAttributes().getPath();
            JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
            PathsToWebDataMapping mapping = new PathsToWebDataMapping(framePath, (List)jsExecutor.executeScript(this.queryJs, new Object[0]));
            this.debug(mapping);
            RootElement frameContent = this.convert(mapping, this.getFrameTitle(frame), framePath);
            FrameConverter frameConverter = new FrameConverter(this.queryJs, this.retestIdProvider, this.defaultValueFinder, framePath + "/");
            frameConverter.addChildrenFromFrames(driver, frameContent);
            frame.addChildren(frameContent.getContainedElements());
        }
        catch (Exception e) {
            log.error("Exception retrieving data content of frame '{}'.", (Object)frame, (Object)e);
        }
    }

    private void debug(PathsToWebDataMapping mapping) {
        LinkedHashMap tagMapping = new LinkedHashMap();
        mapping.forEach(entry -> {
            WebData cfr_ignored_0 = (WebData)tagMapping.put(entry.getKey(), entry.getValue());
        });
        tagMapping.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("pseudo")).forEach(entry -> log.warn("{} | {}", entry.getKey(), (Object)((WebData)entry.getValue()).getKeys().stream().map(key -> key + "=" + ((WebData)entry.getValue()).getAsString((String)key)).collect(Collectors.joining(", "))));
    }

    private WebElement getFrameParent(WebDriver driver, Element frame) {
        String framePath = frame.getIdentifyingAttributes().getPath().substring(this.parentFramePrefix.length());
        String frameXPath = "/" + framePath;
        return driver.findElement(org.openqa.selenium.By.xpath((String)frameXPath));
    }

    private String getFrameTitle(Element frame) {
        String prefix = "frame-";
        Attribute id = frame.getIdentifyingAttributes().getAttribute("id");
        if (id != null) {
            return "frame-" + id.getValue();
        }
        Attribute name = frame.getIdentifyingAttributes().getAttribute("name");
        if (name != null) {
            return "frame-" + name.getValue();
        }
        return "frame-" + frame.getRetestId();
    }

    private RootElement convert(PathsToWebDataMapping mapping, String frameTitle, final String framePath) {
        PeerConverter peerConverter = new PeerConverter(this.retestIdProvider, mapping, frameTitle, null, this.defaultValueFinder, framePath){

            @Override
            protected boolean isRoot(String parentPath) {
                return framePath.equals(parentPath.replaceAll("/$", ""));
            }
        };
        return peerConverter.convertToPeers();
    }

    private static Predicate<Element> isFrame() {
        return element -> {
            String type = element.getIdentifyingAttributes().getType();
            return Stream.of("iframe", "frame").anyMatch(type::equalsIgnoreCase);
        };
    }

    public FrameConverter(String queryJs, RetestIdProvider retestIdProvider, DefaultValueFinder defaultValueFinder, String parentFramePrefix) {
        this.queryJs = queryJs;
        this.retestIdProvider = retestIdProvider;
        this.defaultValueFinder = defaultValueFinder;
        this.parentFramePrefix = parentFramePrefix;
    }
}

