/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.internal;

import de.mannodermaus.rxbonjour.internal.BonjourSchedulers;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Subscription;
import rx.functions.Action1;
import rx.subjects.BehaviorSubject;

public abstract class Backlog<T> {
    private static final Object STOP_MARKER = new Object();
    private BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>(32);
    private BehaviorSubject<Void> subject;
    private Subscription subscription;
    private AtomicBoolean idle = new AtomicBoolean(true);

    public Backlog() {
        this.subject = BehaviorSubject.create();
        this.subscription = this.subject.compose(BonjourSchedulers.backlogSchedulers()).subscribe((Action1)new Action1<Void>(){

            public void call(Void aVoid) {
                try {
                    Object info = Backlog.this.queue.take();
                    if (!STOP_MARKER.equals(info)) {
                        Backlog.this.idle.set(false);
                        Backlog.this.onNext(Backlog.this, info);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public void quit() {
        this.queue.add(STOP_MARKER);
        this.subject.onCompleted();
        this.subscription.unsubscribe();
    }

    public void add(T item) {
        this.queue.add(item);
        if (this.idle.get()) {
            this.proceed();
        }
    }

    public void proceed() {
        this.idle.set(true);
        this.subject.onNext(null);
    }

    public abstract void onNext(Backlog<T> var1, T var2);
}

