/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.discovery;

import android.content.Context;
import android.net.wifi.WifiManager;
import de.mannodermaus.rxbonjour.discovery.BonjourDiscovery;
import de.mannodermaus.rxbonjour.exc.DiscoveryFailed;
import de.mannodermaus.rxbonjour.exc.StaleContextException;
import de.mannodermaus.rxbonjour.internal.BonjourSchedulers;
import de.mannodermaus.rxbonjour.model.BonjourEvent;
import de.mannodermaus.rxbonjour.model.BonjourService;
import de.mannodermaus.rxbonjour.utils.SupportUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.MainThreadSubscription;

final class SupportBonjourDiscovery
extends BonjourDiscovery<SupportUtils> {
    private static final String SUFFIX = ".local.";
    private static final String LOCK_TAG = "RxBonjourDiscovery";

    @Override
    protected SupportUtils createUtils() {
        return SupportUtils.get();
    }

    private BonjourEvent newBonjourEvent(BonjourEvent.Type type, ServiceEvent event) {
        InetAddress[] addresses;
        ServiceInfo info = event.getInfo();
        BonjourService.Builder serviceBuilder = new BonjourService.Builder(event.getName(), event.getType());
        Enumeration keys = info.getPropertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            serviceBuilder.addTxtRecord(key, info.getPropertyString(key));
        }
        for (InetAddress address : addresses = info.getInetAddresses()) {
            if (address == null) continue;
            serviceBuilder.addAddress(address);
        }
        serviceBuilder.setPort(info.getPort());
        return new BonjourEvent(type, serviceBuilder.build());
    }

    @Override
    public Observable<BonjourEvent> start(Context context, String type) {
        final String dnsType = type.endsWith(SUFFIX) ? type : type + SUFFIX;
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<BonjourEvent>(){

            public void call(final Subscriber<? super BonjourEvent> subscriber) {
                Context context = (Context)weakContext.get();
                if (context == null) {
                    subscriber.onError((Throwable)new StaleContextException());
                    return;
                }
                final ServiceListener listener = new ServiceListener(){

                    public void serviceAdded(ServiceEvent event) {
                        event.getDNS().requestServiceInfo(event.getType(), event.getName());
                    }

                    public void serviceRemoved(ServiceEvent event) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)SupportBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.REMOVED, event));
                        }
                    }

                    public void serviceResolved(ServiceEvent event) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)SupportBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.ADDED, event));
                        }
                    }
                };
                WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                final WifiManager.MulticastLock lock = wifiManager.createMulticastLock(SupportBonjourDiscovery.LOCK_TAG);
                lock.setReferenceCounted(true);
                lock.acquire();
                try {
                    final JmDNS jmdns = ((SupportUtils)SupportBonjourDiscovery.this.utils).getManager(context);
                    subscriber.add((Subscription)new MainThreadSubscription(){

                        protected void onUnsubscribe() {
                            jmdns.removeServiceListener(dnsType, listener);
                            ((SupportUtils)SupportBonjourDiscovery.this.utils).decrementSubscriberCount();
                            Observable cleanUpObservable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

                                public void call(Subscriber<? super Void> subscriber) {
                                    lock.release();
                                    ((SupportUtils)SupportBonjourDiscovery.this.utils).closeIfNecessary();
                                    subscriber.unsubscribe();
                                }
                            });
                            cleanUpObservable.compose(BonjourSchedulers.cleanupSchedulers()).subscribe();
                        }
                    });
                    jmdns.addServiceListener(dnsType, listener);
                    ((SupportUtils)SupportBonjourDiscovery.this.utils).incrementSubscriberCount();
                }
                catch (IOException e) {
                    subscriber.onError((Throwable)new DiscoveryFailed(SupportBonjourDiscovery.class, dnsType));
                }
            }
        });
    }

    static {
        Logger.getLogger(DNSIncoming.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(DNSRecordType.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(DNSRecordClass.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(DNSIncoming.MessageInputStream.class.getName()).setLevel(Level.OFF);
    }
}

