/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.rxbonjour.broadcast;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import android.os.Bundle;
import de.mannodermaus.rxbonjour.broadcast.BonjourBroadcast;
import de.mannodermaus.rxbonjour.broadcast.BonjourBroadcastBuilder;
import de.mannodermaus.rxbonjour.exc.BroadcastFailed;
import de.mannodermaus.rxbonjour.exc.StaleContextException;
import de.mannodermaus.rxbonjour.model.BonjourEvent;
import de.mannodermaus.rxbonjour.model.BonjourService;
import de.mannodermaus.rxbonjour.utils.JBUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import rx.Emitter;
import rx.Observable;
import rx.Subscription;
import rx.android.MainThreadSubscription;
import rx.functions.Action1;

@TargetApi(value=16)
final class JBBonjourBroadcast
extends BonjourBroadcast<JBUtils> {
    protected JBBonjourBroadcast(BonjourBroadcastBuilder builder) {
        super(builder);
    }

    @Override
    protected JBUtils createUtils() {
        return JBUtils.get();
    }

    @Override
    public Observable<BonjourEvent> start(Context context) {
        final WeakReference<Context> weakContext = new WeakReference<Context>(context);
        return Observable.create((Action1)new Action1<Emitter<BonjourEvent>>(){

            public void call(final Emitter<BonjourEvent> emitter) {
                Context context = (Context)weakContext.get();
                if (context == null) {
                    emitter.onError((Throwable)new StaleContextException());
                    return;
                }
                try {
                    final BonjourService bonjourService = JBBonjourBroadcast.this.createBonjourService(context);
                    NsdServiceInfo nsdService = JBBonjourBroadcast.this.createServiceInfo(bonjourService);
                    final NsdManager nsdManager = ((JBUtils)JBBonjourBroadcast.this.utils).getManager(context);
                    final NsdManager.RegistrationListener listener = new NsdManager.RegistrationListener(){

                        public void onRegistrationFailed(NsdServiceInfo info, int errorCode) {
                            emitter.onError((Throwable)new BroadcastFailed(JBBonjourBroadcast.class, bonjourService.getName(), errorCode));
                        }

                        public void onUnregistrationFailed(NsdServiceInfo serviceInfo, int errorCode) {
                        }

                        public void onServiceRegistered(NsdServiceInfo info) {
                            emitter.onNext((Object)new BonjourEvent(BonjourEvent.Type.ADDED, bonjourService));
                        }

                        public void onServiceUnregistered(NsdServiceInfo info) {
                            emitter.onNext((Object)new BonjourEvent(BonjourEvent.Type.REMOVED, JBBonjourBroadcast.this.mapNsdServiceInfo(info)));
                        }
                    };
                    nsdManager.registerService(nsdService, 1, listener);
                    emitter.setSubscription((Subscription)new MainThreadSubscription(){

                        protected void onUnsubscribe() {
                            try {
                                nsdManager.unregisterService(listener);
                            }
                            catch (IllegalArgumentException ignored) {
                                ignored.printStackTrace();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    emitter.onError((Throwable)new BroadcastFailed(JBBonjourBroadcast.class, JBBonjourBroadcast.this.type));
                }
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.LATEST);
    }

    private BonjourService mapNsdServiceInfo(NsdServiceInfo info) {
        BonjourService.Builder builder = new BonjourService.Builder(info.getServiceName(), info.getServiceType()).addAddress(info.getHost()).setPort(info.getPort());
        if (Build.VERSION.SDK_INT >= 21) {
            Map attrs = info.getAttributes();
            for (Map.Entry entry : attrs.entrySet()) {
                builder.addTxtRecord((String)entry.getKey(), new String((byte[])entry.getValue(), StandardCharsets.UTF_8));
            }
        }
        return builder.build();
    }

    private NsdServiceInfo createServiceInfo(BonjourService serviceInfo) throws IOException {
        NsdServiceInfo nsdService = new NsdServiceInfo();
        nsdService.setServiceType(serviceInfo.getType());
        nsdService.setServiceName(serviceInfo.getName());
        nsdService.setHost(serviceInfo.getHost());
        nsdService.setPort(serviceInfo.getPort());
        if (Build.VERSION.SDK_INT >= 21) {
            Bundle txtRecordBundle = serviceInfo.getTxtRecords();
            HashMap<String, String> txtRecordMap = new HashMap<String, String>(serviceInfo.getTxtRecordCount());
            for (String key : txtRecordBundle.keySet()) {
                txtRecordMap.put(key, txtRecordBundle.getString(key));
            }
            for (String key : txtRecordMap.keySet()) {
                nsdService.setAttribute(key, (String)txtRecordMap.get(key));
            }
        }
        return nsdService;
    }

    static BonjourBroadcastBuilder newBuilder(String type) {
        return new JBBonjourBroadcastBuilder(type);
    }

    private static final class JBBonjourBroadcastBuilder
    extends BonjourBroadcastBuilder {
        protected JBBonjourBroadcastBuilder(String type) {
            super(type);
        }

        public BonjourBroadcast build() {
            return new JBBonjourBroadcast(this);
        }
    }
}

