/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Backlog<T> {
    private static final Object STOP_MARKER = new Object();
    private BlockingQueue<Object> queue = new LinkedBlockingQueue<Object>(32);
    private final Thread processingThread;
    private AtomicBoolean idle = new AtomicBoolean(true);

    public Backlog() {
        this.processingThread = new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    Object info = Backlog.this.queue.take();
                    while (!Backlog.this.idle.get()) {
                        1.sleep(100L);
                    }
                    if (!STOP_MARKER.equals(info)) {
                        Backlog.this.idle.set(false);
                        Backlog.this.onNext(Backlog.this, info);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.processingThread.start();
    }

    public void quit() {
        this.queue.add(STOP_MARKER);
        this.processingThread.interrupt();
    }

    public void add(T item) {
        this.queue.add(item);
        if (this.idle.get()) {
            this.proceed();
        }
    }

    public void proceed() {
        this.idle.set(true);
    }

    public abstract void onNext(Backlog<T> var1, T var2);
}

