/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour.discovery;

import android.content.Context;
import android.net.wifi.WifiManager;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import rxbonjour.RxBonjourBase;
import rxbonjour.discovery.BonjourDiscovery;
import rxbonjour.exc.DiscoveryFailed;
import rxbonjour.exc.TypeMalformedException;
import rxbonjour.model.BonjourEvent;
import rxbonjour.model.BonjourListener;
import rxbonjour.model.BonjourService;
import rxbonjour.utils.SupportUtils;

final class SupportBonjourDiscovery
extends BonjourDiscovery<SupportUtils> {
    private static final String SUFFIX = ".local.";
    private static final String LOCK_TAG = "RxBonjourDiscovery";
    private JmDNS jmdns;
    private String dnsType;
    private ServiceListener serviceListener;
    private WifiManager.MulticastLock lock;

    @Override
    protected SupportUtils createUtils() {
        return SupportUtils.get();
    }

    private BonjourEvent newBonjourEvent(BonjourEvent.Type type, ServiceEvent event) {
        InetAddress[] addresses;
        ServiceInfo info = event.getInfo();
        BonjourService.Builder serviceBuilder = new BonjourService.Builder(event.getName(), event.getType());
        Enumeration keys = info.getPropertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            serviceBuilder.addTxtRecord(key, info.getPropertyString(key));
        }
        for (InetAddress address : addresses = info.getInetAddresses()) {
            if (address == null) continue;
            serviceBuilder.addAddress(address);
        }
        serviceBuilder.setPort(info.getPort());
        return new BonjourEvent(type, serviceBuilder.build());
    }

    @Override
    public void start(Context context, String type, final BonjourListener listener) {
        if (!RxBonjourBase.isBonjourType(type)) {
            listener.onBonjourError(new TypeMalformedException(type));
            return;
        }
        this.dnsType = type.endsWith(SUFFIX) ? type : type + SUFFIX;
        this.serviceListener = new ServiceListener(){

            public void serviceAdded(ServiceEvent event) {
                event.getDNS().requestServiceInfo(event.getType(), event.getName());
            }

            public void serviceRemoved(ServiceEvent event) {
                listener.onBonjourEvent(SupportBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.REMOVED, event));
            }

            public void serviceResolved(ServiceEvent event) {
                listener.onBonjourEvent(SupportBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.ADDED, event));
            }
        };
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        this.lock = wifiManager.createMulticastLock(LOCK_TAG);
        this.lock.setReferenceCounted(true);
        this.lock.acquire();
        try {
            this.jmdns = ((SupportUtils)this.utils).getManager(context);
            this.jmdns.addServiceListener(this.dnsType, this.serviceListener);
            ((SupportUtils)this.utils).incrementSubscriberCount();
        }
        catch (IOException e) {
            listener.onBonjourError(new DiscoveryFailed(SupportBonjourDiscovery.class, this.dnsType));
        }
    }

    @Override
    public void stop() {
        if (this.jmdns != null) {
            this.jmdns.removeServiceListener(this.dnsType, this.serviceListener);
            ((SupportUtils)this.utils).decrementSubscriberCount();
            new Thread(){

                @Override
                public void run() {
                    super.run();
                    SupportBonjourDiscovery.this.lock.release();
                    ((SupportUtils)SupportBonjourDiscovery.this.utils).closeIfNecessary();
                }
            }.start();
        }
    }

    static {
        Logger.getLogger(DNSIncoming.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(DNSRecordType.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(DNSRecordClass.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(DNSIncoming.MessageInputStream.class.getName()).setLevel(Level.OFF);
    }
}

