/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour.discovery;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import rxbonjour.RxBonjourBase;
import rxbonjour.discovery.BonjourDiscovery;
import rxbonjour.exc.DiscoveryFailed;
import rxbonjour.exc.TypeMalformedException;
import rxbonjour.internal.Backlog;
import rxbonjour.model.BonjourEvent;
import rxbonjour.model.BonjourListener;
import rxbonjour.model.BonjourService;
import rxbonjour.utils.JBUtils;

@TargetApi(value=16)
final class JBBonjourDiscovery
extends BonjourDiscovery<JBUtils> {
    private static int subscriberCount = 0;
    private static NsdManager nsdManager;
    private static Backlog<NsdServiceInfo> resolveBacklog;
    private NsdManager.DiscoveryListener discoveryListener;

    @Override
    protected JBUtils createUtils() {
        return JBUtils.get();
    }

    @TargetApi(value=21)
    private BonjourEvent newBonjourEvent(BonjourEvent.Type type, NsdServiceInfo serviceInfo) {
        BonjourService.Builder serviceBuilder = new BonjourService.Builder(serviceInfo.getServiceName(), serviceInfo.getServiceType());
        if (Build.VERSION.SDK_INT >= 21) {
            Map attributes = serviceInfo.getAttributes();
            for (String key : attributes.keySet()) {
                serviceBuilder.addTxtRecord(key, new String((byte[])attributes.get(key), Charset.forName("UTF-8")));
            }
        }
        serviceBuilder.addAddress(serviceInfo.getHost());
        serviceBuilder.setPort(serviceInfo.getPort());
        return new BonjourEvent(type, serviceBuilder.build());
    }

    @Override
    public void start(Context context, String type, final BonjourListener listener) {
        if (!RxBonjourBase.isBonjourType(type)) {
            listener.onBonjourError(new TypeMalformedException(type));
            return;
        }
        this.discoveryListener = new NsdManager.DiscoveryListener(){

            public void onStartDiscoveryFailed(String serviceType, int errorCode) {
                listener.onBonjourError(new DiscoveryFailed(JBBonjourDiscovery.class, serviceType, errorCode));
            }

            public void onStopDiscoveryFailed(String serviceType, int errorCode) {
                listener.onBonjourError(new DiscoveryFailed(JBBonjourDiscovery.class, serviceType, errorCode));
            }

            public void onDiscoveryStarted(String serviceType) {
            }

            public void onDiscoveryStopped(String serviceType) {
            }

            public void onServiceFound(NsdServiceInfo serviceInfo) {
                resolveBacklog.add(serviceInfo);
            }

            public void onServiceLost(NsdServiceInfo serviceInfo) {
                listener.onBonjourEvent(JBBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.REMOVED, serviceInfo));
            }
        };
        try {
            nsdManager = ((JBUtils)this.utils).getManager(context);
        }
        catch (IOException e) {
            listener.onBonjourError(e);
            return;
        }
        if (resolveBacklog == null) {
            resolveBacklog = new Backlog<NsdServiceInfo>(){

                @Override
                public void onNext(Backlog<NsdServiceInfo> backlog, NsdServiceInfo info) {
                    nsdManager.resolveService(info, new NsdManager.ResolveListener(){

                        public void onResolveFailed(NsdServiceInfo serviceInfo, int errorCode) {
                        }

                        public void onServiceResolved(NsdServiceInfo serviceInfo) {
                            listener.onBonjourEvent(JBBonjourDiscovery.this.newBonjourEvent(BonjourEvent.Type.ADDED, serviceInfo));
                            if (resolveBacklog != null) {
                                resolveBacklog.proceed();
                            }
                        }
                    });
                }
            };
        }
        nsdManager.discoverServices(type, 1, this.discoveryListener);
        ++subscriberCount;
    }

    @Override
    public synchronized void stop() {
        if (nsdManager != null) {
            try {
                nsdManager.stopServiceDiscovery(this.discoveryListener);
                --subscriberCount;
            }
            catch (Exception exception) {
            }
            finally {
                if (subscriberCount <= 0) {
                    resolveBacklog.quit();
                    resolveBacklog = null;
                    nsdManager = null;
                }
            }
        }
    }
}

