/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour.broadcast;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import rxbonjour.RxBonjourBase;
import rxbonjour.broadcast.BonjourBroadcast;
import rxbonjour.broadcast.BonjourBroadcastBuilder;
import rxbonjour.exc.BroadcastFailed;
import rxbonjour.exc.TypeMalformedException;
import rxbonjour.model.BonjourEvent;
import rxbonjour.model.BonjourListener;
import rxbonjour.model.BonjourService;
import rxbonjour.utils.JBUtils;

@TargetApi(value=16)
final class JBBonjourBroadcast
extends BonjourBroadcast<JBUtils> {
    private NsdManager nsdManager;
    private NsdManager.RegistrationListener nsdListener;

    protected JBBonjourBroadcast(BonjourBroadcastBuilder builder) {
        super(builder);
    }

    @Override
    protected JBUtils createUtils() {
        return JBUtils.get();
    }

    @Override
    public void start(@NonNull Context context, final @NonNull BonjourListener listener) {
        if (!RxBonjourBase.isBonjourType(this.type)) {
            listener.onBonjourError(new TypeMalformedException(this.type));
            return;
        }
        try {
            final BonjourService bonjourService = this.createBonjourService(context);
            NsdServiceInfo nsdService = this.createServiceInfo(bonjourService);
            this.nsdManager = ((JBUtils)this.utils).getManager(context);
            this.nsdListener = new NsdManager.RegistrationListener(){

                public void onRegistrationFailed(NsdServiceInfo info, int errorCode) {
                    listener.onBonjourError(new BroadcastFailed(JBBonjourBroadcast.class, bonjourService.getName(), errorCode));
                }

                public void onUnregistrationFailed(NsdServiceInfo serviceInfo, int errorCode) {
                }

                public void onServiceRegistered(NsdServiceInfo info) {
                    listener.onBonjourEvent(new BonjourEvent(BonjourEvent.Type.ADDED, bonjourService));
                }

                public void onServiceUnregistered(NsdServiceInfo info) {
                    listener.onBonjourEvent(new BonjourEvent(BonjourEvent.Type.REMOVED, JBBonjourBroadcast.this.mapNsdServiceInfo(info)));
                }
            };
            this.nsdManager.registerService(nsdService, 1, this.nsdListener);
        }
        catch (IOException e) {
            listener.onBonjourError(new BroadcastFailed(JBBonjourBroadcast.class, this.type));
        }
    }

    @Override
    public void stop() {
        if (this.nsdManager != null) {
            try {
                this.nsdManager.unregisterService(this.nsdListener);
            }
            catch (IllegalArgumentException ignored) {
                ignored.printStackTrace();
            }
        }
    }

    private BonjourService mapNsdServiceInfo(NsdServiceInfo info) {
        BonjourService.Builder builder = new BonjourService.Builder(info.getServiceName(), info.getServiceType()).addAddress(info.getHost()).setPort(info.getPort());
        if (Build.VERSION.SDK_INT >= 21) {
            Map attrs = info.getAttributes();
            for (Map.Entry entry : attrs.entrySet()) {
                builder.addTxtRecord((String)entry.getKey(), new String((byte[])entry.getValue(), StandardCharsets.UTF_8));
            }
        }
        return builder.build();
    }

    private NsdServiceInfo createServiceInfo(BonjourService serviceInfo) throws IOException {
        NsdServiceInfo nsdService = new NsdServiceInfo();
        nsdService.setServiceType(serviceInfo.getType());
        nsdService.setServiceName(serviceInfo.getName());
        nsdService.setHost(serviceInfo.getHost());
        nsdService.setPort(serviceInfo.getPort());
        if (Build.VERSION.SDK_INT >= 21) {
            Bundle txtRecordBundle = serviceInfo.getTxtRecords();
            HashMap<String, String> txtRecordMap = new HashMap<String, String>(serviceInfo.getTxtRecordCount());
            for (String key : txtRecordBundle.keySet()) {
                txtRecordMap.put(key, txtRecordBundle.getString(key));
            }
            for (String key : txtRecordMap.keySet()) {
                nsdService.setAttribute(key, (String)txtRecordMap.get(key));
            }
        }
        return nsdService;
    }

    static class Builder
    extends BonjourBroadcastBuilder {
        Builder(String type) {
            super(type);
        }

        public BonjourBroadcast build() {
            return new JBBonjourBroadcast(this);
        }
    }
}

