/*
 * Decompiled with CFR 0.152.
 */
package rxbonjour.broadcast;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.NonNull;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import rxbonjour.broadcast.BonjourBroadcastBuilder;
import rxbonjour.broadcast.JBBonjourBroadcast;
import rxbonjour.broadcast.SupportBonjourBroadcast;
import rxbonjour.model.BonjourListener;
import rxbonjour.model.BonjourService;
import rxbonjour.utils.BonjourUtils;

public abstract class BonjourBroadcast<T extends BonjourUtils<?>> {
    protected final InetAddress address;
    protected final String name;
    protected final String type;
    protected final int port;
    protected final Map<String, String> txtRecords;
    protected final T utils;

    protected BonjourBroadcast(BonjourBroadcastBuilder builder) {
        this.address = builder.address();
        this.name = builder.name();
        this.type = builder.type();
        this.port = builder.port();
        this.txtRecords = builder.txtRecords();
        this.utils = this.createUtils();
    }

    protected BonjourService createBonjourService(Context context) throws IOException {
        InetAddress ia = this.address;
        if (ia == null) {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            ia = ((BonjourUtils)this.utils).getInetAddress(wifiManager);
        }
        BonjourService.Builder serviceBuilder = new BonjourService.Builder(this.name, this.type).setPort(this.port).addAddress(ia);
        if (this.txtRecords != null) {
            for (String key : this.txtRecords.keySet()) {
                serviceBuilder.addTxtRecord(key, this.txtRecords.get(key));
            }
        }
        return serviceBuilder.build();
    }

    protected abstract T createUtils();

    public abstract void start(@NonNull Context var1, @NonNull BonjourListener var2);

    public abstract void stop();

    public static BonjourBroadcastBuilder newBuilder(String type) {
        return BonjourBroadcast.newBuilder(type, false);
    }

    public static BonjourBroadcastBuilder newBuilder(String type, boolean forceNsdManager) {
        if (forceNsdManager && Build.VERSION.SDK_INT >= 16) {
            return new JBBonjourBroadcast.Builder(type);
        }
        return new SupportBonjourBroadcast.Builder(type);
    }
}

