/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.gradle.plugins.junit5;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.builder.model.Version;
import de.mannodermaus.gradle.plugins.junit5.AndroidJUnitPlatformExtension;
import de.mannodermaus.gradle.plugins.junit5.AndroidJUnitPlatformPlugin;
import de.mannodermaus.gradle.plugins.junit5.DslKt;
import de.mannodermaus.gradle.plugins.junit5.ExtensionsKt;
import de.mannodermaus.gradle.plugins.junit5.JUnit5TaskConfig;
import de.mannodermaus.gradle.plugins.junit5.JacocoOptions;
import de.mannodermaus.gradle.plugins.junit5.ProjectConfig;
import de.mannodermaus.gradle.plugins.junit5.providers.DirectoryProvider;
import de.mannodermaus.gradle.plugins.junit5.providers.JavaDirectoryProvider;
import de.mannodermaus.gradle.plugins.junit5.providers.KotlinDirectoryProvider;
import de.mannodermaus.gradle.plugins.junit5.tasks.AndroidJUnit5JacocoReport;
import de.mannodermaus.gradle.plugins.junit5.tasks.AndroidJUnit5WriteFilters;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u0007*\u00020\u0002H\u0002J\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0002H\u0002J\f\u0010\u0010\u001a\u00020\u0007*\u00020\u0002H\u0002J\f\u0010\u0011\u001a\u00020\u0007*\u00020\u0002H\u0002J\f\u0010\u0012\u001a\u00020\u0007*\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/mannodermaus/gradle/plugins/junit5/AndroidJUnitPlatformPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "projectConfig", "Lde/mannodermaus/gradle/plugins/junit5/ProjectConfig;", "apply", "", "project", "collectDirectoryProviders", "", "Lde/mannodermaus/gradle/plugins/junit5/providers/DirectoryProvider;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "configureExtensions", "configureInstrumentationTests", "configureJacocoTasks", "configureUnitTests", "evaluateDsl", "android-junit5"})
public final class AndroidJUnitPlatformPlugin
implements Plugin<Project> {
    private ProjectConfig projectConfig;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.requireGradle("6.1.1", (Function0<String>)((Function0)apply.1.INSTANCE));
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.requireVersion(string, "3.5.0", (Function0<String>)((Function0)apply.2.INSTANCE));
        this.projectConfig = new ProjectConfig(project);
        this.configureExtensions(project);
        project.afterEvaluate((Action)new Action<Project>(this){
            final /* synthetic */ AndroidJUnitPlatformPlugin this$0;

            public final void execute(Project it) {
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                AndroidJUnitPlatformPlugin.access$evaluateDsl(this.this$0, project);
                AndroidJUnitPlatformPlugin.access$configureUnitTests(this.this$0, it);
                AndroidJUnitPlatformPlugin.access$configureInstrumentationTests(this.this$0, it);
                AndroidJUnitPlatformPlugin.access$configureJacocoTasks(this.this$0, it);
            }
            {
                this.this$0 = androidJUnitPlatformPlugin;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void configureExtensions(@NotNull Project $this$configureExtensions) {
        void $this$forEach$iv;
        Iterable iterable = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.excludedPackagingOptions();
        PackagingOptions packagingOptions = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getAndroid($this$configureExtensions).getPackagingOptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p1 = (String)element$iv;
            boolean bl = false;
            packagingOptions.exclude(p1);
        }
        ProjectConfig projectConfig = this.projectConfig;
        if (projectConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectConfig");
        }
        DslKt.attachDsl($this$configureExtensions, projectConfig);
    }

    private final void evaluateDsl(@NotNull Project $this$evaluateDsl) {
        DslKt.evaluateDsl($this$evaluateDsl);
    }

    private final void configureUnitTests(@NotNull Project $this$configureUnitTests) {
        ProjectConfig projectConfig = this.projectConfig;
        if (projectConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectConfig");
        }
        projectConfig.getVariants().all((Action)new Action<BaseVariant>($this$configureUnitTests){
            final /* synthetic */ Project $this_configureUnitTests;

            public final void execute(BaseVariant variant) {
                TaskContainer taskContainer = this.$this_configureUnitTests.getTasks();
                Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"tasks");
                BaseVariant baseVariant = variant;
                Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant, (String)"variant");
                AndroidUnitTest androidUnitTest = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.testTaskOf(taskContainer, baseVariant);
                if (androidUnitTest == null) {
                    return;
                }
                AndroidUnitTest testTask = androidUnitTest;
                JUnit5TaskConfig configuration = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.junit5ConfigurationOf(this.$this_configureUnitTests, variant);
                testTask.useJUnitPlatform((Action)new Action<JUnitPlatformOptions>(configuration){
                    final /* synthetic */ JUnit5TaskConfig $configuration;

                    public final void execute(JUnitPlatformOptions options) {
                        String[] stringArray = this.$configuration.getCombinedIncludeTags();
                        options.includeTags(Arrays.copyOf(stringArray, stringArray.length));
                        String[] stringArray2 = this.$configuration.getCombinedExcludeTags();
                        options.excludeTags(Arrays.copyOf(stringArray2, stringArray2.length));
                        String[] stringArray3 = this.$configuration.getCombinedIncludeEngines();
                        options.includeEngines(Arrays.copyOf(stringArray3, stringArray3.length));
                        String[] stringArray4 = this.$configuration.getCombinedExcludeEngines();
                        options.excludeEngines(Arrays.copyOf(stringArray4, stringArray4.length));
                    }
                    {
                        this.$configuration = jUnit5TaskConfig;
                    }
                });
                String[] stringArray = configuration.getCombinedIncludePatterns();
                testTask.include(Arrays.copyOf(stringArray, stringArray.length));
                String[] stringArray2 = configuration.getCombinedExcludePatterns();
                testTask.exclude(Arrays.copyOf(stringArray2, stringArray2.length));
                TestOptions testOptions = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getAndroid(this.$this_configureUnitTests).getTestOptions();
                Intrinsics.checkExpressionValueIsNotNull((Object)testOptions, (String)"android.testOptions");
                AndroidJUnitPlatformExtension junit5 = ExtensionsKt.getJunitPlatform(testOptions);
                testTask.systemProperties(junit5.getConfigurationParameters());
            }
            {
                this.$this_configureUnitTests = project;
            }
        });
    }

    private final void configureInstrumentationTests(@NotNull Project $this$configureInstrumentationTests) {
        boolean bl;
        boolean hasRunnerBuilder;
        block6: {
            DefaultConfig defaultConfig = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getAndroid($this$configureInstrumentationTests).getDefaultConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultConfig, (String)"android.defaultConfig");
            Map map = defaultConfig.getTestInstrumentationRunnerArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"android.defaultConfig\n  \u2026umentationRunnerArguments");
            hasRunnerBuilder = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getAsList$default(map, "runnerBuilder", null, 2, null).contains("de.mannodermaus.junit5.AndroidJUnit5Builder");
            Configuration configuration = $this$configureInstrumentationTests.getConfigurations().getByName("androidTestRuntimeOnly");
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configurations\n        .\u2026\"androidTestRuntimeOnly\")");
            DependencySet dependencySet = configuration.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"configurations\n        .\u2026y\")\n        .dependencies");
            Iterable $this$any$iv = (Iterable)dependencySet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Dependency it = (Dependency)element$iv;
                    boolean bl2 = false;
                    Dependency dependency = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"it");
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"de.mannodermaus.junit5") && Intrinsics.areEqual((Object)it.getName(), (Object)"android-test-runner"))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean hasDependency = bl;
        Project project = $this$configureInstrumentationTests.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        TestOptions testOptions = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getAndroid(project).getTestOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)testOptions, (String)"project.android.testOptions");
        AndroidJUnitPlatformExtension extension = ExtensionsKt.getJunitPlatform(testOptions);
        boolean checkEnabled = extension.getInstrumentationTests().getIntegrityCheckEnabled();
        if (checkEnabled && hasRunnerBuilder ^ hasDependency) {
            String missingStep = hasRunnerBuilder ? "Add the android-test-runner library to the androidTestRuntimeOnly configuration's dependencies" : "Add the JUnit 5 RunnerBuilder to the application's defaultConfig";
            throw (Throwable)new GradleException(StringsKt.trimMargin$default((String)("Incomplete configuration for JUnit 5 instrumentation tests: " + missingStep + ".\n        |Find more information at: https://bit.ly/junit5-instrumentation-tests"), null, (int)1, null));
        }
        if (hasRunnerBuilder && hasDependency) {
            ProjectConfig projectConfig = this.projectConfig;
            if (projectConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectConfig");
            }
            projectConfig.getVariants().all((Action)new Action<BaseVariant>($this$configureInstrumentationTests){
                final /* synthetic */ Project $this_configureInstrumentationTests;

                public final void execute(BaseVariant variant) {
                    BaseVariant baseVariant = variant;
                    Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant, (String)"variant");
                    TestVariant instrumentationTestVariant = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getInstrumentationTestVariant(baseVariant);
                    if (instrumentationTestVariant != null) {
                        AndroidJUnit5WriteFilters writerTask = AndroidJUnit5WriteFilters.Companion.create(this.$this_configureInstrumentationTests, instrumentationTestVariant);
                        ConfigurableFileCollection outputFolder = this.$this_configureInstrumentationTests.files(new Object[]{writerTask.getOutputFolder()}).builtBy(new Object[]{writerTask});
                        instrumentationTestVariant.registerGeneratedResFolders((FileCollection)outputFolder);
                    }
                }
                {
                    this.$this_configureInstrumentationTests = project;
                }
            });
        }
    }

    private final void configureJacocoTasks(@NotNull Project $this$configureJacocoTasks) {
        ProjectConfig projectConfig = this.projectConfig;
        if (projectConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectConfig");
        }
        boolean isJacocoApplied = projectConfig.getJacocoPluginApplied();
        TestOptions testOptions = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.getAndroid($this$configureJacocoTasks).getTestOptions();
        Intrinsics.checkExpressionValueIsNotNull((Object)testOptions, (String)"this.android.testOptions");
        JacocoOptions jacocoOptions = ExtensionsKt.getJunitPlatform(testOptions).getJacocoOptions();
        if (isJacocoApplied && jacocoOptions.getTaskGenerationEnabled()) {
            ProjectConfig projectConfig2 = this.projectConfig;
            if (projectConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectConfig");
            }
            projectConfig2.getVariants().all((Action)new Action<BaseVariant>(this, $this$configureJacocoTasks, jacocoOptions){
                final /* synthetic */ AndroidJUnitPlatformPlugin this$0;
                final /* synthetic */ Project $this_configureJacocoTasks;
                final /* synthetic */ JacocoOptions $jacocoOptions;

                public final void execute(BaseVariant variant) {
                    AndroidJUnit5JacocoReport jacocoTask;
                    BaseVariant baseVariant = variant;
                    Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant, (String)"variant");
                    Collection directoryProviders = AndroidJUnitPlatformPlugin.access$collectDirectoryProviders(this.this$0, this.$this_configureJacocoTasks, baseVariant);
                    TaskContainer taskContainer = this.$this_configureJacocoTasks.getTasks();
                    Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"tasks");
                    AndroidUnitTest androidUnitTest = de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.testTaskOf(taskContainer, variant);
                    if (androidUnitTest == null) {
                        return;
                    }
                    AndroidUnitTest testTask = androidUnitTest;
                    Set<String> enabledVariants = this.$jacocoOptions.getOnlyGenerateTasksForVariants();
                    if ((enabledVariants.isEmpty() || enabledVariants.contains(variant.getName())) && (jacocoTask = AndroidJUnit5JacocoReport.Companion.create(this.$this_configureJacocoTasks, variant, (Test)testTask, directoryProviders)) == null) {
                        Project project = this.$this_configureJacocoTasks.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        Logger logger = project.getLogger();
                        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
                        de.mannodermaus.gradle.plugins.junit5.internal.ExtensionsKt.junit5Warn(logger, "Jacoco task for variant '" + variant.getName() + "' already exists. Disabling customization for JUnit 5...");
                    }
                }
                {
                    this.this$0 = androidJUnitPlatformPlugin;
                    this.$this_configureJacocoTasks = project;
                    this.$jacocoOptions = jacocoOptions;
                }
            });
        }
    }

    private final Collection<DirectoryProvider> collectDirectoryProviders(@NotNull Project $this$collectDirectoryProviders, BaseVariant variant) {
        boolean bl = false;
        Set providers = new LinkedHashSet();
        Collection collection = providers;
        DirectoryProvider directoryProvider = new JavaDirectoryProvider(variant);
        boolean bl2 = false;
        collection.add(directoryProvider);
        ProjectConfig projectConfig = this.projectConfig;
        if (projectConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectConfig");
        }
        if (projectConfig.getKotlinPluginApplied()) {
            collection = providers;
            directoryProvider = new KotlinDirectoryProvider($this$collectDirectoryProviders, variant);
            bl2 = false;
            collection.add(directoryProvider);
        }
        return providers;
    }

    public static final /* synthetic */ void access$evaluateDsl(AndroidJUnitPlatformPlugin $this, Project $this$access_u24evaluateDsl) {
        $this.evaluateDsl($this$access_u24evaluateDsl);
    }

    public static final /* synthetic */ void access$configureUnitTests(AndroidJUnitPlatformPlugin $this, Project $this$access_u24configureUnitTests) {
        $this.configureUnitTests($this$access_u24configureUnitTests);
    }

    public static final /* synthetic */ void access$configureInstrumentationTests(AndroidJUnitPlatformPlugin $this, Project $this$access_u24configureInstrumentationTests) {
        $this.configureInstrumentationTests($this$access_u24configureInstrumentationTests);
    }

    public static final /* synthetic */ void access$configureJacocoTasks(AndroidJUnitPlatformPlugin $this, Project $this$access_u24configureJacocoTasks) {
        $this.configureJacocoTasks($this$access_u24configureJacocoTasks);
    }

    public static final /* synthetic */ Collection access$collectDirectoryProviders(AndroidJUnitPlatformPlugin $this, Project $this$access_u24collectDirectoryProviders, BaseVariant variant) {
        return $this.collectDirectoryProviders($this$access_u24collectDirectoryProviders, variant);
    }
}

