/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.MongoCmdOptions;
import de.flapdoodle.embed.mongo.config.MongoCommonConfig;
import de.flapdoodle.embed.mongo.config.MongosConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.immutables.value.Generated;

@Generated(from="MongosConfig", generator="Immutables")
public final class ImmutableMongosConfig
implements MongosConfig {
    private final Long stopTimeoutInMillis;
    private final IFeatureAwareVersion version;
    private final Timeout timeout;
    private final Net net;
    private final MongoCmdOptions cmdOptions;
    private final String password;
    private final String userName;
    private final String configDB;
    private final String replicaSet;
    private final Map<String, String> args;
    private final String pidFile;
    private final SupportConfig supportConfig;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongosConfig(Builder builder) {
        this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
        this.version = builder.version;
        this.configDB = builder.configDB;
        this.args = ImmutableMongosConfig.createUnmodifiableMap(false, false, builder.args);
        if (builder.timeout != null) {
            this.initShim.timeout(builder.timeout);
        }
        if (builder.net != null) {
            this.initShim.net(builder.net);
        }
        if (builder.cmdOptions != null) {
            this.initShim.cmdOptions(builder.cmdOptions);
        }
        if (builder.password != null) {
            this.initShim.password(builder.password);
        }
        if (builder.userName != null) {
            this.initShim.userName(builder.userName);
        }
        if (builder.replicaSet != null) {
            this.initShim.replicaSet(builder.replicaSet);
        }
        if (builder.pidFile != null) {
            this.initShim.pidFile(builder.pidFile);
        }
        if (builder.supportConfig != null) {
            this.initShim.supportConfig(builder.supportConfig);
        }
        this.timeout = this.initShim.timeout();
        this.net = this.initShim.net();
        this.cmdOptions = this.initShim.cmdOptions();
        this.password = this.initShim.password();
        this.userName = this.initShim.userName();
        this.replicaSet = this.initShim.replicaSet();
        this.pidFile = this.initShim.pidFile();
        this.supportConfig = this.initShim.supportConfig();
        this.initShim = null;
    }

    private ImmutableMongosConfig(Long stopTimeoutInMillis, IFeatureAwareVersion version, Timeout timeout, Net net, MongoCmdOptions cmdOptions, String password, String userName, String configDB, String replicaSet, Map<String, String> args, String pidFile, SupportConfig supportConfig) {
        this.stopTimeoutInMillis = stopTimeoutInMillis;
        this.version = version;
        this.timeout = timeout;
        this.net = net;
        this.cmdOptions = cmdOptions;
        this.password = password;
        this.userName = userName;
        this.configDB = configDB;
        this.replicaSet = replicaSet;
        this.args = args;
        this.pidFile = pidFile;
        this.supportConfig = supportConfig;
        this.initShim = null;
    }

    private Timeout timeoutInitialize() {
        return MongosConfig.super.timeout();
    }

    private Net netInitialize() {
        return MongosConfig.super.net();
    }

    private MongoCmdOptions cmdOptionsInitialize() {
        return MongosConfig.super.cmdOptions();
    }

    private String passwordInitialize() {
        return MongosConfig.super.password();
    }

    private String userNameInitialize() {
        return MongosConfig.super.userName();
    }

    private String replicaSetInitialize() {
        return MongosConfig.super.replicaSet();
    }

    private String pidFileInitialize() {
        return MongosConfig.super.pidFile();
    }

    private SupportConfig supportConfigInitialize() {
        return MongosConfig.super.supportConfig();
    }

    public OptionalLong stopTimeoutInMillis() {
        return this.stopTimeoutInMillis != null ? OptionalLong.of(this.stopTimeoutInMillis) : OptionalLong.empty();
    }

    @Override
    public IFeatureAwareVersion version() {
        return this.version;
    }

    @Override
    public Timeout timeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.timeout() : this.timeout;
    }

    @Override
    public Net net() {
        InitShim shim = this.initShim;
        return shim != null ? shim.net() : this.net;
    }

    @Override
    public MongoCmdOptions cmdOptions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cmdOptions() : this.cmdOptions;
    }

    @Override
    public String password() {
        InitShim shim = this.initShim;
        return shim != null ? shim.password() : this.password;
    }

    @Override
    public String userName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.userName() : this.userName;
    }

    @Override
    public String getConfigDB() {
        return this.configDB;
    }

    @Override
    public String replicaSet() {
        InitShim shim = this.initShim;
        return shim != null ? shim.replicaSet() : this.replicaSet;
    }

    @Override
    public Map<String, String> args() {
        return this.args;
    }

    @Override
    public String pidFile() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pidFile() : this.pidFile;
    }

    @Override
    public SupportConfig supportConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportConfig() : this.supportConfig;
    }

    public final ImmutableMongosConfig withStopTimeoutInMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.stopTimeoutInMillis, newValue)) {
            return this;
        }
        return new ImmutableMongosConfig(newValue, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withStopTimeoutInMillis(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.stopTimeoutInMillis, value)) {
            return this;
        }
        return new ImmutableMongosConfig(value, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withVersion(IFeatureAwareVersion value) {
        if (this.version == value) {
            return this;
        }
        IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, newValue, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withTimeout(Timeout value) {
        if (this.timeout == value) {
            return this;
        }
        Timeout newValue = Objects.requireNonNull(value, "timeout");
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, newValue, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withNet(Net value) {
        if (this.net == value) {
            return this;
        }
        Net newValue = Objects.requireNonNull(value, "net");
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, newValue, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withCmdOptions(MongoCmdOptions value) {
        if (this.cmdOptions == value) {
            return this;
        }
        MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, newValue, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, newValue, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withUserName(String value) {
        String newValue = Objects.requireNonNull(value, "userName");
        if (this.userName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, newValue, this.configDB, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withConfigDB(String value) {
        String newValue = Objects.requireNonNull(value, "configDB");
        if (this.configDB.equals(newValue)) {
            return this;
        }
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, newValue, this.replicaSet, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withReplicaSet(String value) {
        String newValue = Objects.requireNonNull(value, "replicaSet");
        if (this.replicaSet.equals(newValue)) {
            return this;
        }
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, newValue, this.args, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withArgs(Map<String, ? extends String> entries) {
        if (this.args == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableMongosConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, newValue, this.pidFile, this.supportConfig);
    }

    public final ImmutableMongosConfig withPidFile(String value) {
        String newValue = Objects.requireNonNull(value, "pidFile");
        if (this.pidFile.equals(newValue)) {
            return this;
        }
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, newValue, this.supportConfig);
    }

    public final ImmutableMongosConfig withSupportConfig(SupportConfig value) {
        if (this.supportConfig == value) {
            return this;
        }
        SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
        return new ImmutableMongosConfig(this.stopTimeoutInMillis, this.version, this.timeout, this.net, this.cmdOptions, this.password, this.userName, this.configDB, this.replicaSet, this.args, this.pidFile, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongosConfig && this.equalTo(0, (ImmutableMongosConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongosConfig another) {
        return Objects.equals(this.stopTimeoutInMillis, another.stopTimeoutInMillis) && this.version.equals(another.version) && this.timeout.equals(another.timeout) && this.net.equals(another.net) && this.cmdOptions.equals(another.cmdOptions) && this.password.equals(another.password) && this.userName.equals(another.userName) && this.configDB.equals(another.configDB) && this.replicaSet.equals(another.replicaSet) && this.args.equals(another.args) && this.pidFile.equals(another.pidFile) && this.supportConfig.equals(another.supportConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.stopTimeoutInMillis);
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.timeout.hashCode();
        h += (h << 5) + this.net.hashCode();
        h += (h << 5) + this.cmdOptions.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + this.configDB.hashCode();
        h += (h << 5) + this.replicaSet.hashCode();
        h += (h << 5) + this.args.hashCode();
        h += (h << 5) + this.pidFile.hashCode();
        h += (h << 5) + this.supportConfig.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongosConfig{");
        if (this.stopTimeoutInMillis != null) {
            builder.append("stopTimeoutInMillis=").append(this.stopTimeoutInMillis);
        }
        if (builder.length() > 13) {
            builder.append(", ");
        }
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("timeout=").append(this.timeout);
        builder.append(", ");
        builder.append("net=").append(this.net);
        builder.append(", ");
        builder.append("cmdOptions=").append(this.cmdOptions);
        builder.append(", ");
        builder.append("password=").append(this.password);
        builder.append(", ");
        builder.append("userName=").append(this.userName);
        builder.append(", ");
        builder.append("configDB=").append(this.configDB);
        builder.append(", ");
        builder.append("replicaSet=").append(this.replicaSet);
        builder.append(", ");
        builder.append("args=").append(this.args);
        builder.append(", ");
        builder.append("pidFile=").append(this.pidFile);
        builder.append(", ");
        builder.append("supportConfig=").append(this.supportConfig);
        return builder.append("}").toString();
    }

    public static ImmutableMongosConfig copyOf(MongosConfig instance) {
        if (instance instanceof ImmutableMongosConfig) {
            return (ImmutableMongosConfig)instance;
        }
        return ImmutableMongosConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="MongosConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_CONFIG_D_B = 2L;
        private long initBits = 3L;
        private Long stopTimeoutInMillis;
        private IFeatureAwareVersion version;
        private Timeout timeout;
        private Net net;
        private MongoCmdOptions cmdOptions;
        private String password;
        private String userName;
        private String configDB;
        private String replicaSet;
        private Map<String, String> args = new LinkedHashMap<String, String>();
        private String pidFile;
        private SupportConfig supportConfig;

        private Builder() {
        }

        public final Builder from(MongoCommonConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExecutableProcessConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MongosConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            OptionalLong stopTimeoutInMillisOptional;
            MongoCommonConfig instance;
            long bits = 0L;
            if (object instanceof MongoCommonConfig) {
                instance = (MongoCommonConfig)object;
                if ((bits & 1L) == 0L) {
                    this.password(instance.password());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.supportConfig(instance.supportConfig());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
                    if (stopTimeoutInMillisOptional.isPresent()) {
                        this.stopTimeoutInMillis(stopTimeoutInMillisOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.cmdOptions(instance.cmdOptions());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.net(instance.net());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.userName(instance.userName());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.version(instance.version());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.timeout(instance.timeout());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.pidFile(instance.pidFile());
                    bits |= 0x100L;
                }
            }
            if (object instanceof ExecutableProcessConfig) {
                instance = (ExecutableProcessConfig)object;
                if ((bits & 2L) == 0L) {
                    this.supportConfig(instance.supportConfig());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
                    if (stopTimeoutInMillisOptional.isPresent()) {
                        this.stopTimeoutInMillis(stopTimeoutInMillisOptional);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof MongosConfig) {
                instance = (MongosConfig)object;
                this.putAllArgs(instance.args());
                if ((bits & 1L) == 0L) {
                    this.password(instance.password());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.supportConfig(instance.supportConfig());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
                    if (stopTimeoutInMillisOptional.isPresent()) {
                        this.stopTimeoutInMillis(stopTimeoutInMillisOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.cmdOptions(instance.cmdOptions());
                    bits |= 8L;
                }
                this.configDB(instance.getConfigDB());
                if ((bits & 0x10L) == 0L) {
                    this.net(instance.net());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.userName(instance.userName());
                    bits |= 0x20L;
                }
                this.replicaSet(instance.replicaSet());
                if ((bits & 0x40L) == 0L) {
                    this.version(instance.version());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.timeout(instance.timeout());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.pidFile(instance.pidFile());
                    bits |= 0x100L;
                }
            }
        }

        public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
            this.stopTimeoutInMillis = stopTimeoutInMillis;
            return this;
        }

        public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
            this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? Long.valueOf(stopTimeoutInMillis.getAsLong()) : null;
            return this;
        }

        public final Builder version(IFeatureAwareVersion version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timeout(Timeout timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            return this;
        }

        public final Builder net(Net net) {
            this.net = Objects.requireNonNull(net, "net");
            return this;
        }

        public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
            this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            return this;
        }

        public final Builder configDB(String configDB) {
            this.configDB = Objects.requireNonNull(configDB, "configDB");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder replicaSet(String replicaSet) {
            this.replicaSet = Objects.requireNonNull(replicaSet, "replicaSet");
            return this;
        }

        public final Builder putArgs(String key, String value) {
            this.args.put(Objects.requireNonNull(key, "args key"), value == null ? Objects.requireNonNull(value, "args value for key: " + key) : value);
            return this;
        }

        public final Builder putArgs(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.args.put(Objects.requireNonNull(k, "args key"), v == null ? Objects.requireNonNull(v, "args value for key: " + k) : v);
            return this;
        }

        public final Builder args(Map<String, ? extends String> entries) {
            this.args.clear();
            return this.putAllArgs(entries);
        }

        public final Builder putAllArgs(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.args.put(Objects.requireNonNull(k, "args key"), v == null ? Objects.requireNonNull(v, "args value for key: " + k) : v);
            }
            return this;
        }

        public final Builder pidFile(String pidFile) {
            this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
            return this;
        }

        public final Builder supportConfig(SupportConfig supportConfig) {
            this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
            return this;
        }

        public ImmutableMongosConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongosConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("configDB");
            }
            return "Cannot build MongosConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MongosConfig", generator="Immutables")
    private final class InitShim {
        private byte timeoutBuildStage = 0;
        private Timeout timeout;
        private byte netBuildStage = 0;
        private Net net;
        private byte cmdOptionsBuildStage = 0;
        private MongoCmdOptions cmdOptions;
        private byte passwordBuildStage = 0;
        private String password;
        private byte userNameBuildStage = 0;
        private String userName;
        private byte replicaSetBuildStage = 0;
        private String replicaSet;
        private byte pidFileBuildStage = 0;
        private String pidFile;
        private byte supportConfigBuildStage = 0;
        private SupportConfig supportConfig;

        private InitShim() {
        }

        Timeout timeout() {
            if (this.timeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timeoutBuildStage == 0) {
                this.timeoutBuildStage = (byte)-1;
                this.timeout = Objects.requireNonNull(ImmutableMongosConfig.this.timeoutInitialize(), "timeout");
                this.timeoutBuildStage = 1;
            }
            return this.timeout;
        }

        void timeout(Timeout timeout) {
            this.timeout = timeout;
            this.timeoutBuildStage = 1;
        }

        Net net() {
            if (this.netBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.netBuildStage == 0) {
                this.netBuildStage = (byte)-1;
                this.net = Objects.requireNonNull(ImmutableMongosConfig.this.netInitialize(), "net");
                this.netBuildStage = 1;
            }
            return this.net;
        }

        void net(Net net) {
            this.net = net;
            this.netBuildStage = 1;
        }

        MongoCmdOptions cmdOptions() {
            if (this.cmdOptionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cmdOptionsBuildStage == 0) {
                this.cmdOptionsBuildStage = (byte)-1;
                this.cmdOptions = Objects.requireNonNull(ImmutableMongosConfig.this.cmdOptionsInitialize(), "cmdOptions");
                this.cmdOptionsBuildStage = 1;
            }
            return this.cmdOptions;
        }

        void cmdOptions(MongoCmdOptions cmdOptions) {
            this.cmdOptions = cmdOptions;
            this.cmdOptionsBuildStage = 1;
        }

        String password() {
            if (this.passwordBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.passwordBuildStage == 0) {
                this.passwordBuildStage = (byte)-1;
                this.password = Objects.requireNonNull(ImmutableMongosConfig.this.passwordInitialize(), "password");
                this.passwordBuildStage = 1;
            }
            return this.password;
        }

        void password(String password) {
            this.password = password;
            this.passwordBuildStage = 1;
        }

        String userName() {
            if (this.userNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userNameBuildStage == 0) {
                this.userNameBuildStage = (byte)-1;
                this.userName = Objects.requireNonNull(ImmutableMongosConfig.this.userNameInitialize(), "userName");
                this.userNameBuildStage = 1;
            }
            return this.userName;
        }

        void userName(String userName) {
            this.userName = userName;
            this.userNameBuildStage = 1;
        }

        String replicaSet() {
            if (this.replicaSetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.replicaSetBuildStage == 0) {
                this.replicaSetBuildStage = (byte)-1;
                this.replicaSet = Objects.requireNonNull(ImmutableMongosConfig.this.replicaSetInitialize(), "replicaSet");
                this.replicaSetBuildStage = 1;
            }
            return this.replicaSet;
        }

        void replicaSet(String replicaSet) {
            this.replicaSet = replicaSet;
            this.replicaSetBuildStage = 1;
        }

        String pidFile() {
            if (this.pidFileBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pidFileBuildStage == 0) {
                this.pidFileBuildStage = (byte)-1;
                this.pidFile = Objects.requireNonNull(ImmutableMongosConfig.this.pidFileInitialize(), "pidFile");
                this.pidFileBuildStage = 1;
            }
            return this.pidFile;
        }

        void pidFile(String pidFile) {
            this.pidFile = pidFile;
            this.pidFileBuildStage = 1;
        }

        SupportConfig supportConfig() {
            if (this.supportConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportConfigBuildStage == 0) {
                this.supportConfigBuildStage = (byte)-1;
                this.supportConfig = Objects.requireNonNull(ImmutableMongosConfig.this.supportConfigInitialize(), "supportConfig");
                this.supportConfigBuildStage = 1;
            }
            return this.supportConfig;
        }

        void supportConfig(SupportConfig supportConfig) {
            this.supportConfig = supportConfig;
            this.supportConfigBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.timeoutBuildStage == -1) {
                attributes.add("timeout");
            }
            if (this.netBuildStage == -1) {
                attributes.add("net");
            }
            if (this.cmdOptionsBuildStage == -1) {
                attributes.add("cmdOptions");
            }
            if (this.passwordBuildStage == -1) {
                attributes.add("password");
            }
            if (this.userNameBuildStage == -1) {
                attributes.add("userName");
            }
            if (this.replicaSetBuildStage == -1) {
                attributes.add("replicaSet");
            }
            if (this.pidFileBuildStage == -1) {
                attributes.add("pidFile");
            }
            if (this.supportConfigBuildStage == -1) {
                attributes.add("supportConfig");
            }
            return "Cannot build MongosConfig, attribute initializers form cycle " + attributes;
        }
    }
}

