/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.mongo.packageresolver.linux.CentosPackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.linux.DebianPackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuPackageResolver;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.CentosVersion;
import de.flapdoodle.os.linux.DebianVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.Optional;

public class LinuxPackageFinder
implements PackageFinder {
    private final Command command;
    private final ImmutablePlatformMatchRules rules;

    public LinuxPackageFinder(Command command) {
        this.command = command;
        this.rules = LinuxPackageFinder.rules(command);
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static ImmutablePlatformMatchRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        ImmutablePlatformMatchRule ubuntuRule = PlatformMatchRule.builder().match(PlatformMatch.withOs(OS.Linux).withVersion((Version[])UbuntuVersion.values())).finder(new UbuntuPackageResolver(command)).build();
        ImmutablePlatformMatchRule debianRule = PlatformMatchRule.builder().match(PlatformMatch.withOs(OS.Linux).withVersion((Version[])DebianVersion.values())).finder(new DebianPackageResolver(command)).build();
        ImmutablePlatformMatchRule centosRule = PlatformMatchRule.builder().match(PlatformMatch.withOs(OS.Linux).withVersion((Version[])CentosVersion.values())).finder(new CentosPackageResolver(command)).build();
        ImmutablePlatformMatchRule legacy32 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14"), VersionRange.of("2.6.0", "2.6.12")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B32))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-i686-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule legacy64 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14"), VersionRange.of("2.6.0", "2.6.12")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule hiddenLegacy64 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule hiddenLegacy32 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B32))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-i686-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule failIfNothingMatches = PlatformMatchRule.builder().match(PlatformMatch.withOs(OS.Linux)).finder(distribution -> {
            throw new IllegalArgumentException("linux distribution not supported: " + distribution);
        }).build();
        return PlatformMatchRules.empty().withRules(ubuntuRule, debianRule, centosRule, legacy32, legacy64, hiddenLegacy64, hiddenLegacy32, failIfNothingMatches);
    }
}

