/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.MongoImportConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MongoImport
extends AbstractMongo {
    public static List<String> getCommandLine(MongoImportConfig config, ExtractedFileSet files) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(files.executable().getAbsolutePath()));
        if (config.cmdOptions().isVerbose()) {
            ret.add("-v");
        }
        Net net = config.net();
        ret.add("--port");
        ret.add("" + net.getPort());
        if (net.isIpv6()) {
            ret.add("--ipv6");
        }
        if (net.getBindIp() != null) {
            ret.add("--host");
            ret.add(net.getBindIp());
        }
        if (config.getDatabaseName() != null) {
            ret.add("--db");
            ret.add(config.getDatabaseName());
        }
        if (config.getCollectionName() != null) {
            ret.add("--collection");
            ret.add(config.getCollectionName());
        }
        if (config.isJsonArray()) {
            ret.add("--jsonArray");
        }
        if (config.isDropCollection()) {
            ret.add("--drop");
        }
        if (config.isUpsertDocuments()) {
            ret.add("--upsert");
        }
        if (config.getImportFile() != null) {
            ret.add("--file");
            ret.add(config.getImportFile());
        }
        if (config.isHeaderline()) {
            ret.add("--headerline");
        }
        if (config.getType() != null) {
            ret.add("--type");
            ret.add(config.getType());
        }
        return ret;
    }
}

