/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.BitSize;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.distribution.Platform;

public class Paths
implements IPackageResolver {
    private final Command command;

    public Paths(Command command) {
        this.command = command;
    }

    public FileSet getFileSet(Distribution distribution) {
        String executableFileName;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: 
            case Solaris: 
            case FreeBSD: {
                executableFileName = this.command.commandName();
                break;
            }
            case Windows: {
                executableFileName = this.command.commandName() + ".exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return FileSet.builder().addEntry(FileType.Executable, executableFileName).build();
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: 
            case Solaris: 
            case FreeBSD: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.ZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return archiveType;
    }

    public String getPath(Distribution distribution) {
        String sbitSize;
        String splatform;
        String sarchiveType;
        String sversion = Paths.getVersionPart(distribution.getVersion());
        ArchiveType archiveType = this.getArchiveType(distribution);
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tgz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + archiveType);
            }
        }
        switch (distribution.getPlatform()) {
            case Linux: {
                splatform = "linux";
                break;
            }
            case Windows: {
                splatform = "win32";
                break;
            }
            case OS_X: {
                splatform = "osx";
                break;
            }
            case Solaris: {
                splatform = "sunos5";
                break;
            }
            case FreeBSD: {
                splatform = "freebsd";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        block11 : switch (distribution.getBitsize()) {
            case B32: {
                switch (distribution.getPlatform()) {
                    case Linux: {
                        sbitSize = "i686";
                        break block11;
                    }
                    case Windows: {
                        sbitSize = "i386";
                        break block11;
                    }
                    case OS_X: {
                        sbitSize = "i386";
                        break block11;
                    }
                }
                throw new IllegalArgumentException("Platform " + distribution.getPlatform() + " not supported yet on 32Bit Platform");
            }
            case B64: {
                sbitSize = "x86_64";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown BitSize " + distribution.getBitsize());
            }
        }
        if (distribution.getBitsize() == BitSize.B64 && distribution.getPlatform() == Platform.Windows && this.useWindows2008PlusVersion()) {
            sversion = "2008plus-" + sversion;
        }
        return splatform + "/mongodb-" + splatform + "-" + sbitSize + "-" + sversion + "." + sarchiveType;
    }

    protected boolean useWindows2008PlusVersion() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows Server 2008 R2")) {
            return true;
        }
        return osName.contains("Windows 7");
    }

    protected static String getVersionPart(IVersion version) {
        return version.asInDownloadPath();
    }
}

