/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import de.flapdoodle.embed.mongo.spring.autoconfigure.ImmutableCredentials;
import de.flapdoodle.embed.mongo.spring.autoconfigure.ImmutableMongoClientAction;
import de.flapdoodle.embed.mongo.spring.autoconfigure.ImmutableRunCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.bson.Document;
import org.immutables.value.Value;

@Value.Immutable
abstract class MongoClientAction {
    MongoClientAction() {
    }

    public abstract Optional<Credentials> credentials();

    public abstract Action action();

    @Value.Default
    public Consumer<Document> onResult() {
        return result -> {
            if ((Double)result.get((Object)"ok", Double.class) < 1.0) {
                throw new IllegalArgumentException("" + this.action() + " failed with " + result);
            }
        };
    }

    @Value.Default
    public Consumer<RuntimeException> onError() {
        return ex -> {
            throw new RuntimeException("" + this.action() + " failed", (Throwable)ex);
        };
    }

    static ImmutableMongoClientAction createUser(String database, String username, char[] password, String ... roles) {
        return MongoClientAction.runCommand(database, MongoClientAction.createUser(username, new String(password), roles));
    }

    static ImmutableMongoClientAction shutdown(String database) {
        return MongoClientAction.runCommand(database, MongoClientAction.shutdownForced());
    }

    static ImmutableMongoClientAction runCommand(String database, Document command) {
        return MongoClientAction.of(ImmutableRunCommand.of(database, command));
    }

    static Credentials credentials(String database, String username, char[] password) {
        return ImmutableCredentials.builder().database(database).username(username).password(new String(password)).build();
    }

    static ImmutableMongoClientAction.Builder builder() {
        return ImmutableMongoClientAction.builder();
    }

    static ImmutableMongoClientAction of(Action action) {
        return ImmutableMongoClientAction.builder().action(action).build();
    }

    private static Document createUser(String username, String pwd, String ... roles) {
        return new Document("createUser", (Object)username).append("pwd", (Object)pwd).append("roles", Arrays.asList(roles));
    }

    private static Document role(String rolename, String database) {
        return new Document("role", (Object)rolename).append("db", (Object)database);
    }

    private static Document createUser(String username, String pwd, Document ... roles) {
        return new Document("createUser", (Object)username).append("pwd", (Object)pwd).append("roles", Arrays.asList(roles));
    }

    private static Document privilege(String database, String ... actions) {
        return new Document("resource", (Object)new Document("db", (Object)database).append("collection", (Object)"")).append("actions", Arrays.asList(actions));
    }

    private static Document createRole(String roleName, Collection<String> roles, Document ... privileges) {
        return new Document("createRole", (Object)roleName).append("privileges", Arrays.asList(privileges)).append("roles", new ArrayList<String>(roles));
    }

    private static Document createRole(String roleName, Document ... privileges) {
        return MongoClientAction.createRole(roleName, Collections.emptyList(), privileges);
    }

    private static Document shutdownForced() {
        return new Document().append("shutdown", (Object)1).append("force", (Object)true);
    }

    static Document listCollections() {
        return new Document("listCollections", (Object)1);
    }

    static abstract class Action {
        Action() {
        }

        @Value.Parameter
        public abstract String database();
    }

    @Value.Immutable
    static abstract class RunCommand
    extends Action {
        RunCommand() {
        }

        @Value.Parameter
        public abstract Document command();
    }

    @Value.Immutable
    static abstract class Credentials {
        Credentials() {
        }

        public abstract String database();

        public abstract String username();

        public abstract String password();
    }
}

