/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.process.distribution.Distribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface DistributionMatch {
    public boolean match(Distribution var1);

    default public DistributionMatch andThen(DistributionMatch other) {
        return new AndThen(this, other);
    }

    public static DistributionMatch all() {
        return new All();
    }

    public static DistributionMatch any(DistributionMatch ... matcher) {
        return new Any(matcher);
    }

    public static DistributionMatch any(List<? extends DistributionMatch> matcher) {
        return new Any(matcher);
    }

    public static class Any
    implements DistributionMatch {
        private final List<DistributionMatch> matcher;

        public Any(DistributionMatch ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Any(List<? extends DistributionMatch> matcher) {
            this.matcher = Collections.unmodifiableList(new ArrayList<DistributionMatch>(matcher));
        }

        public List<DistributionMatch> matcher() {
            return this.matcher;
        }

        @Override
        public boolean match(Distribution distribution) {
            return this.matcher.stream().anyMatch(m -> m.match(distribution));
        }
    }

    public static class All
    implements DistributionMatch {
        @Override
        public boolean match(Distribution distribution) {
            return true;
        }
    }

    public static class AndThen
    implements DistributionMatch {
        private final DistributionMatch first;
        private final DistributionMatch second;

        public AndThen(DistributionMatch first, DistributionMatch second) {
            this.first = first;
            this.second = second;
        }

        public DistributionMatch first() {
            return this.first;
        }

        public DistributionMatch second() {
            return this.second;
        }

        @Override
        public boolean match(Distribution distribution) {
            return this.first.match(distribution) && this.second.match(distribution);
        }
    }
}

