package de.cidaas.jwt;

public class Options {
	
	private Integer notValidBeforeLeeway;
	private String secret;
	private boolean JWEToken;
	private String publicKey;
	private String publicKeyPath;
	private String privateKey;
	private String privateKeyPath;

	public Integer getNotValidBeforeLeeway() {
		return notValidBeforeLeeway;
	}

	/**
	 * Set JWT claim "nbf" to current timestamp minus this value. Overrides
	 * content of <code>claims</code> in <code>sign()</code>.
	 */
	public Options setNotValidBeforeLeeway(Integer notValidBeforeLeeway) {
		this.notValidBeforeLeeway = notValidBeforeLeeway;
		return this;
	}
	
	/**
	 * @return the secret
	 */
	public String getSecret() {
		return secret;
	}

	/**
	 * @param secret
	 *            the secret to set
	 */
	public void setSecret(String secret) {
		this.secret = secret;
	}

	
	/**
	 * @return the publicKey
	 */
	public String getPublicKey() {
		return publicKey;
	}

	/**
	 * @param publicKey the publicKey to set
	 */
	public void setPublicKey(String publicKey) {
		this.publicKey = publicKey;
	}

	/**
	 * @return the privateKey
	 */
	public String getPrivateKey() {
		return privateKey;
	}

	/**
	 * @param privateKey the privateKey to set
	 */
	public void setPrivateKey(String privateKey) {
		this.privateKey = privateKey;
	}

	/**
	 * @return the jWEToken
	 */
	public boolean isJWEToken() {
		return JWEToken;
	}

	/**
	 * @param jWEToken the jWEToken to set
	 */
	public void setJWEToken(boolean jWEToken) {
		JWEToken = jWEToken;
	}

	/**
	 * @return the publicKeyPath
	 */
	public String getPublicKeyPath() {
		return publicKeyPath;
	}

	/**
	 * @param publicKeyPath the publicKeyPath to set
	 */
	public void setPublicKeyPath(String publicKeyPath) {
		this.publicKeyPath = publicKeyPath;
	}

	/**
	 * @return the privateKeyPath
	 */
	public String getPrivateKeyPath() {
		return privateKeyPath;
	}

	/**
	 * @param privateKeyPath the privateKeyPath to set
	 */
	public void setPrivateKeyPath(String privateKeyPath) {
		this.privateKeyPath = privateKeyPath;
	}
	
	

}
