package de.cidaas.oauth.windowupdate;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HTTP;

import com.fasterxml.jackson.databind.ObjectMapper;

import de.cidaas.oauth.interceptor.Constants;
import de.cidaas.oauth.model.TokenCheckEntity;

public class TokenWindowUpdate {

	public List<TokenCheckEntity> tokenList = new ArrayList<>();

	private static TokenWindowUpdate _instance;

	public static synchronized TokenWindowUpdate getInstance() {
		if (_instance == null) {
			_instance = new TokenWindowUpdate();
			System.out.println("Initialize the update executer");
			try {
				ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

				UpdateTask task1 = new UpdateTask();
				executor.scheduleAtFixedRate(task1, 2, Constants.get_token_usage_update_interval(), TimeUnit.SECONDS);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return _instance;
	}
}

class UpdateTask implements Runnable {

	public void run() {
		List<TokenCheckEntity> tokenList = new ArrayList<>();
		TokenWindowUpdate instance = TokenWindowUpdate.getInstance();
		try {

			if (instance.tokenList != null && instance.tokenList.size() > 0) {
				while (tokenList.size() < Constants.get_max_token_usage_update_count()
						&& instance.tokenList.size() > 0) {
					if (instance.tokenList.size() > 0) {
						tokenList.add(instance.tokenList.remove(0));
					}
				}
			}

			if (tokenList != null && tokenList.size() > 0) {
				System.out.println(
						"Sending " + tokenList.size() + "/" + instance.tokenList.size() + " request to cidaas");
				String jsonData = new ObjectMapper().writeValueAsString(tokenList);
				postWebhookThread pw = new postWebhookThread(Constants.get_update_token_check_urll(), jsonData);
				pw.start();
			}

		} catch (Exception e) {
			if (tokenList != null && tokenList.size() > 0) {
				instance.tokenList.addAll(tokenList);
			}
			System.out.println(
					"Error while submiting access token usage data to Cidaas, Dont worry we will retry same in a bit.");
			e.printStackTrace();
		}
	}

	public class postWebhookThread extends Thread {
		private String urlToSubmit;
		private String jsonData;

		public postWebhookThread(String urlToSubmit, String jsonData) {
			this.urlToSubmit = urlToSubmit;
			this.jsonData = jsonData;
		}

		public void run() {
			try {

				HttpPost resetPost = new HttpPost(new URI(urlToSubmit));

				if (jsonData != null) {
					StringEntity se = new StringEntity(jsonData, ContentType.APPLICATION_JSON);
					resetPost.setEntity(se);
					resetPost.addHeader(HTTP.CONTENT_TYPE, "application/json; charset=UTF-8");
				}

				HttpResponse result = HttpClientBuilder.create().build().execute(resetPost);

				BufferedReader rd = new BufferedReader(new InputStreamReader(result.getEntity().getContent()));

				StringBuffer resultData = new StringBuffer();
				String line = "";
				while ((line = rd.readLine()) != null) {
					resultData.append(line);
				}

				System.out.println(result);

			} catch (Exception e) {
				e.printStackTrace();

			}
		}
	}
}
