package de.cidaas.oauth.interceptor;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

/**
 * The Class ServiceClientHelper.
 *
 * @author : thomaswidmann
 * @since: 10.12.2016
 *         <p>
 * 				copyright: WidasConcepts 2016
 *         </p>
 */
public class ServiceClientHelper {

	/**
	 * Instantiates a new service client helper.
	 */
	private ServiceClientHelper() {
	}

	/**
	 * Creates the http client.
	 *
	 * @return the closeable http client
	 */
	public static CloseableHttpClient createHttpClient() {
		return HttpClientBuilder.create().build();
	}

	/**
	 * Creates the http client.
	 *
	 * @param config
	 *          the config
	 * @return the closeable http client
	 */
	public static CloseableHttpClient createHttpClient(RequestConfig config) {
		if (config != null) {
			return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
		}
		return createHttpClient();
	}
}
