package de.cidaas.oauth.interceptor;

import static org.apache.oltu.oauth2.rs.ResourceServer.getQueryParameterValue;

import javax.servlet.http.HttpServletRequest;

import org.apache.oltu.oauth2.rs.extractor.BearerQueryTokenExtractor;

/**
 * The Class CBBearerQueryTokenExtractor.
 *
 * @author Michael Scheuner
 */
class CBBearerQueryTokenExtractor extends BearerQueryTokenExtractor {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.oltu.oauth2.rs.extractor.BearerQueryTokenExtractor#
	 * getAccessToken(javax.servlet.http.HttpServletRequest)
	 */
	@Override
	public String getAccessToken(HttpServletRequest request) {
		String token = getQueryParameterValue(request, Constants.get_tokenKey());
		if (token == null) {
			token = super.getAccessToken(request);
		}
		return token;
	}
}
