/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.stage;

import de.carne.boot.ShutdownHooks;
import de.carne.boot.logging.Log;
import de.carne.jfx.fxml.FXMLController;
import de.carne.jfx.scene.control.DialogController;
import de.carne.util.Lazy;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuBar;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.jdt.annotation.Nullable;

public abstract class StageController
extends FXMLController<Stage> {
    private static final Log LOG = new Log();
    private static final boolean TEST_MODE_ENABLED = Boolean.getBoolean("enableTestMode");
    private static final Lazy<ScheduledExecutorService> EXECUTOR_SERVICE = new Lazy(Executors::newSingleThreadScheduledExecutor);
    private final AtomicInteger backgroundTaskCount = new AtomicInteger(0);

    protected static ScheduledExecutorService getExecutorService() {
        return (ScheduledExecutorService)EXECUTOR_SERVICE.get();
    }

    public static <C extends StageController> C loadPrimaryStage(Stage primaryStage, Class<C> controllerClass) throws IOException {
        return (C)StageController.loadUI(null, c -> primaryStage, controllerClass);
    }

    public <C extends StageController> C loadStage(Class<C> controllerClass) throws IOException {
        return (C)StageController.loadUI((Window)this.getUI(), c -> new Stage(), controllerClass);
    }

    @Override
    public final Window getWindow() {
        return (Window)this.getUI();
    }

    @Override
    protected void setupUI(@Nullable Window owner, Stage stage, Parent fxmlRoot) {
        stage.setOnCloseRequest(evt -> this.onCloseRequest((WindowEvent)evt));
        stage.setScene(new Scene(fxmlRoot));
        stage.initStyle(this.getStyle());
        if (owner != null) {
            stage.initOwner(owner);
            stage.initModality(this.getModality());
        } else {
            this.setSystemMenuBar();
        }
        stage.setResizable(this.getResizable());
        this.setupStage(stage);
    }

    public <R, C extends DialogController<R>> C loadDialog(Function<C, Dialog<R>> dialogFactory, Class<C> controllerClass) throws IOException {
        return DialogController.loadDialog((Window)this.getUI(), dialogFactory, controllerClass);
    }

    protected void setSystemMenuBar() {
        if (!TEST_MODE_ENABLED) {
            Parent root = ((Stage)this.getUI()).getScene().getRoot();
            for (Node node : root.getChildrenUnmodifiable()) {
                if (!(node instanceof MenuBar)) continue;
                ((MenuBar)node).setUseSystemMenuBar(true);
                break;
            }
        }
    }

    protected StageStyle getStyle() {
        return StageStyle.DECORATED;
    }

    protected Modality getModality() {
        return Modality.WINDOW_MODAL;
    }

    protected boolean getResizable() {
        return true;
    }

    protected void setupStage(Stage stage) {
    }

    protected void setBlocked(boolean blocked) {
        ((Stage)this.getUI()).getScene().getRoot().setDisable(blocked);
    }

    public boolean isBlocked() {
        return this.backgroundTaskCount.get() != 0;
    }

    protected @Nullable Preferences getPreferences() {
        return null;
    }

    public void show() {
        Stage stage = (Stage)this.getUI();
        stage.sizeToScene();
        stage.show();
    }

    public void showAndWait() {
        Stage stage = (Stage)this.getUI();
        stage.sizeToScene();
        stage.showAndWait();
    }

    public void close(boolean sync) {
        if (sync) {
            this.syncPreferences();
        }
        ((Stage)this.getUI()).close();
    }

    public void syncPreferences() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            try {
                preferences.sync();
            }
            catch (BackingStoreException e) {
                LOG.warning((Throwable)e, "An error occurred while syncing preferences ''{0}''", new Object[]{preferences});
            }
        }
    }

    private void onCloseRequest(WindowEvent evt) {
        if (this.isBlocked()) {
            evt.consume();
        }
    }

    final void onTaskScheduled() {
        if (this.backgroundTaskCount.getAndIncrement() == 0) {
            this.setBlocked(true);
        }
    }

    final void onTaskFinished() {
        if (this.backgroundTaskCount.decrementAndGet() == 0) {
            this.setBlocked(false);
        }
    }

    static {
        ShutdownHooks.add(() -> EXECUTOR_SERVICE.getOptional().ifPresent(ExecutorService::shutdown));
    }

    protected abstract class BackgroundTask<V>
    extends Task<V> {
        protected BackgroundTask() {
        }

        protected void scheduled() {
            StageController.this.onTaskScheduled();
        }

        protected void succeeded() {
            StageController.this.onTaskFinished();
        }

        protected void cancelled() {
            StageController.this.onTaskFinished();
        }

        protected void failed() {
            StageController.this.onTaskFinished();
        }
    }
}

