/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.image;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import javafx.scene.image.Image;
import org.eclipse.jdt.annotation.Nullable;

public final class ImageRegistry<K> {
    private final NavigableMap<CompositeKey, Image> imageMap = new TreeMap<CompositeKey, Image>();
    private final Comparator<K> comparator;

    public ImageRegistry(Comparator<K> comparator) {
        this.comparator = comparator;
    }

    public Image registerImage(K key, Image image) {
        return this.imageMap.put(new CompositeKey(key, image.getHeight(), image.getWidth()), image);
    }

    public @Nullable Image getImage(K key) {
        return this.getImage(key, 0.0, null);
    }

    public @Nullable Image getImage(K key, @Nullable Image def) {
        return this.getImage(key, 0.0, def);
    }

    public @Nullable Image getImage(K key, double size) {
        return this.getImage(key, size, null);
    }

    public @Nullable Image getImage(K key, double size, @Nullable Image def) {
        CompositeKey searchKey = new CompositeKey(key, size);
        Map.Entry<CompositeKey, Image> entry = this.imageMap.ceilingEntry(searchKey);
        if (entry == null || !entry.getKey().baseKey().equals(key)) {
            entry = this.imageMap.lowerEntry(searchKey);
        }
        return entry != null && entry.getKey().baseKey().equals(key) ? entry.getValue() : def;
    }

    int compareBaseKey(K o1, K o2) {
        return this.comparator.compare(o1, o2);
    }

    private final class CompositeKey
    implements Comparable<CompositeKey> {
        private final K baseKey;
        private final int sizeKey;

        public CompositeKey(K baseKey, double height, double width) {
            this.baseKey = baseKey;
            this.sizeKey = (int)(height * width);
        }

        public CompositeKey(K baseKey, double size) {
            this.baseKey = baseKey;
            this.sizeKey = size > 0.0 ? (int)(size * size) : Integer.MAX_VALUE;
        }

        public K baseKey() {
            return this.baseKey;
        }

        @Override
        public int compareTo(@Nullable CompositeKey _o) {
            CompositeKey o = Objects.requireNonNull(_o);
            int comparison = ImageRegistry.this.compareBaseKey(this.baseKey, o.baseKey);
            if (comparison == 0) {
                comparison = Integer.compare(this.sizeKey, o.sizeKey);
            }
            return comparison;
        }

        public int hashCode() {
            return Objects.hash(this.baseKey, this.sizeKey);
        }

        public boolean equals(@Nullable Object obj) {
            boolean equal = false;
            if (this == obj) {
                equal = true;
            } else if (obj instanceof CompositeKey) {
                CompositeKey o = (CompositeKey)obj;
                equal = this.baseKey.equals(o.baseKey) && this.sizeKey == o.sizeKey;
            }
            return equal;
        }
    }
}

