/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.control;

import de.carne.util.Late;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ListViewEditor<T> {
    private final Late<ListView<T>> listViewParam = new Late();

    public ListViewEditor<T> init(ListView<T> listView) {
        ListView initializedListView = (ListView)this.listViewParam.set(listView);
        initializedListView.getSelectionModel().selectedItemProperty().addListener((p, o, n) -> this.setInput(n));
        return this;
    }

    public ListViewEditor<T> setAddCommand(Button cmdButton) {
        cmdButton.setOnAction(this::onAddAction);
        return this;
    }

    public ListViewEditor<T> setApplyCommand(Button cmdButton) {
        ListView<T> listView = this.getListView();
        cmdButton.disableProperty().bind((ObservableValue)listView.getSelectionModel().selectedItemProperty().isNull());
        cmdButton.setOnAction(evt -> this.onApplyAction((ActionEvent)evt));
        return this;
    }

    public ListViewEditor<T> setDeleteCommand(Button cmdButton) {
        ListView<T> listView = this.getListView();
        cmdButton.disableProperty().bind((ObservableValue)listView.getSelectionModel().selectedItemProperty().isNull());
        cmdButton.setOnAction(evt -> this.onDeleteAction((ActionEvent)evt));
        return this;
    }

    public ListViewEditor<T> setMoveUpCommand(Button cmdButton) {
        ListView<T> listView = this.getListView();
        cmdButton.disableProperty().bind((ObservableValue)listView.getSelectionModel().selectedItemProperty().isNull());
        cmdButton.setOnAction(evt -> this.onMoveUpAction((ActionEvent)evt));
        return this;
    }

    public ListViewEditor<T> setMoveDownCommand(Button cmdButton) {
        ListView<T> listView = this.getListView();
        cmdButton.disableProperty().bind((ObservableValue)listView.getSelectionModel().selectedItemProperty().isNull());
        cmdButton.setOnAction(evt -> this.onMoveDownAction((ActionEvent)evt));
        return this;
    }

    protected abstract @Nullable T getInput();

    protected abstract void setInput(@Nullable T var1);

    public void onAddAction(ActionEvent evt) {
        T input = this.getInput();
        if (input != null) {
            ListView<T> listView = this.getListView();
            int addIndex = Math.max(0, listView.getSelectionModel().getSelectedIndex() + 1);
            listView.getItems().add(addIndex, input);
            listView.getSelectionModel().select(addIndex);
        }
    }

    public void onApplyAction(ActionEvent evt) {
        T input;
        ListView<T> listView = this.getListView();
        int applyIndex = listView.getSelectionModel().getSelectedIndex();
        if (applyIndex >= 0 && (input = this.getInput()) != null) {
            listView.getItems().set(applyIndex, input);
        }
    }

    public void onDeleteAction(ActionEvent evt) {
        ListView<T> listView = this.getListView();
        int deleteIndex = listView.getSelectionModel().getSelectedIndex();
        if (deleteIndex >= 0) {
            listView.getItems().remove(deleteIndex);
        }
    }

    public void onMoveUpAction(ActionEvent evt) {
        ListView<T> listView = this.getListView();
        int moveFromIndex = listView.getSelectionModel().getSelectedIndex();
        if (moveFromIndex > 0) {
            ObservableList items = listView.getItems();
            Object item = items.get(moveFromIndex);
            int moveToIndex = moveFromIndex - 1;
            items.set(moveFromIndex, items.get(moveToIndex));
            items.set(moveToIndex, item);
            listView.getSelectionModel().select(moveToIndex);
        }
    }

    public void onMoveDownAction(ActionEvent evt) {
        ObservableList items;
        ListView<T> listView = this.getListView();
        int moveFromIndex = listView.getSelectionModel().getSelectedIndex();
        int moveToIndex = moveFromIndex + 1;
        if (moveToIndex < (items = listView.getItems()).size()) {
            Object item = items.get(moveFromIndex);
            items.set(moveFromIndex, items.get(moveToIndex));
            items.set(moveToIndex, item);
            listView.getSelectionModel().select(moveToIndex);
        }
    }

    private ListView<T> getListView() {
        return (ListView)this.listViewParam.get();
    }
}

