/*
 * I18N resource strings
 *
 * Generated on 17.02.2019 08:19:17
 */
package de.carne.jfx.scene.control.aboutinfo;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * Package localization resources.
 */
public final class AboutInfoI18N {

	/**
	 * The BUNDLE represented by this class.
	 */
	public static final ResourceBundle BUNDLE = ResourceBundle.getBundle(AboutInfoI18N.class.getName());

	/**
	 * Format a resource string.
	 * @param key The resource key.
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String format(String key, Object... arguments) {
		String pattern = BUNDLE.getString(key);

		return (arguments.length > 0 ? MessageFormat.format(pattern, arguments) : pattern);
	}

	/**
	 * Resource key {@code STR_TEXT_HEADER}
	 * <p>
	 * {0}<br>Version: {1}<br>Build: {2}
	 */
	public static final String STR_TEXT_HEADER = "STR_TEXT_HEADER";

	/**
	 * Resource string {@code STR_TEXT_HEADER}
	 * <p>
	 * {0}<br>Version: {1}<br>Build: {2}
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_TEXT_HEADER(Object... arguments) {
		return format(STR_TEXT_HEADER, arguments);
	}

	/**
	 * Resource key {@code STR_STAGE_TITLE}
	 * <p>
	 * About {0}
	 */
	public static final String STR_STAGE_TITLE = "STR_STAGE_TITLE";

	/**
	 * Resource string {@code STR_STAGE_TITLE}
	 * <p>
	 * About {0}
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_STAGE_TITLE(Object... arguments) {
		return format(STR_STAGE_TITLE, arguments);
	}

}
