/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.control.aboutinfo;

import de.carne.check.Nullable;
import de.carne.jfx.scene.control.DialogController;
import de.carne.jfx.scene.control.aboutinfo.AboutInfoI18N;
import de.carne.util.AboutInfo;
import de.carne.util.Exceptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;

public class AboutInfoController
extends DialogController<ButtonType> {
    @FXML
    private TabPane ctlInfoTabs;

    @Override
    protected void setupDialog(Dialog<ButtonType> dialog) {
        dialog.setTitle(AboutInfoI18N.formatSTR_STAGE_TITLE(AboutInfo.PROJECT_ID));
        dialog.setHeaderText(AboutInfoI18N.formatSTR_TEXT_HEADER(AboutInfo.PROJECT_NAME, AboutInfo.PROJECT_VERSION, AboutInfo.PROJECT_BUILD));
    }

    public AboutInfoController setLogo(Image image) {
        ((Dialog)this.getUI()).setGraphic((Node)new ImageView(image));
        return this;
    }

    public AboutInfoController addInfo(@Nullable URL url) {
        if (url != null) {
            try (BufferedReader infoReader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String infoTextLine;
                String infoTitle = infoReader.readLine();
                if (infoTitle == null) {
                    throw new IllegalArgumentException("Empty info resource: " + url);
                }
                StringBuilder infoTextBuffer = new StringBuilder();
                while ((infoTextLine = infoReader.readLine()) != null) {
                    infoTextBuffer.append(infoTextLine).append('\n');
                }
                TextArea infoTextArea = new TextArea(infoTextBuffer.toString());
                infoTextArea.setEditable(false);
                AnchorPane infoTextPane = new AnchorPane(new Node[]{infoTextArea});
                AnchorPane.setLeftAnchor((Node)infoTextArea, (Double)0.0);
                AnchorPane.setTopAnchor((Node)infoTextArea, (Double)0.0);
                AnchorPane.setRightAnchor((Node)infoTextArea, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)infoTextArea, (Double)0.0);
                this.ctlInfoTabs.getTabs().add((Object)new Tab(infoTitle, (Node)infoTextPane));
            }
            catch (IOException e) {
                Exceptions.warn((Throwable)e);
            }
        }
        return this;
    }
}

