/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.prefs;

import de.carne.check.Nullable;
import de.carne.util.Exceptions;
import de.carne.util.prefs.Preference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.prefs.Preferences;

public class PathPreference
extends Preference<Path> {
    public static final Predicate<Path> IS_REGULAR_FILE = x$0 -> Files.isRegularFile(x$0, new LinkOption[0]);
    public static final Predicate<Path> IS_DIRECTORY = x$0 -> Files.isDirectory(x$0, new LinkOption[0]);
    private final Predicate<Path> validator;

    public PathPreference(Preferences preferences, String key) {
        this(preferences, key, p -> true);
    }

    public PathPreference(Preferences preferences, String key, Predicate<Path> validator) {
        super(preferences, key);
        this.validator = validator;
    }

    @Nullable
    public File getValueAsFile() {
        return this.getValueAsFile(null);
    }

    @Nullable
    public File getValueAsFile(@Nullable File defaultValue) {
        Path value = (Path)this.get();
        return value != null ? value.toFile() : defaultValue;
    }

    public void putValueFromFile(@Nullable File value) {
        this.put(value != null ? value.toPath() : null);
    }

    @Override
    @Nullable
    protected Path toValue(String valueString) {
        Path value = null;
        try {
            value = this.validatePath(Paths.get(valueString, new String[0]));
        }
        catch (InvalidPathException e) {
            Exceptions.ignore(e);
        }
        return value;
    }

    @Override
    protected String fromValue(Path value) {
        return value.toString();
    }

    @Nullable
    private Path validatePath(@Nullable Path path) {
        return path == null || this.validator.test(path) ? path : null;
    }
}

