/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.check.Nullable;
import de.carne.util.PropertiesHelper;
import de.carne.util.logging.Log;
import de.carne.util.logging.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogMonitor
extends Handler {
    private static final int BUFFER_LIMIT = PropertiesHelper.getInt(LogMonitor.class, ".limit", 100);
    private final Deque<LogRecord> buffer = new LinkedList<LogRecord>();
    private final Set<Long> threadIds = new HashSet<Long>();
    private final LogLevel level;

    public LogMonitor(LogLevel level) {
        this.level = level;
    }

    public synchronized void includeThread(Thread thread) {
        this.threadIds.add(thread.getId());
    }

    public synchronized void excludeThread(Thread thread) {
        this.threadIds.remove(thread.getId());
    }

    public synchronized boolean notEmpty() {
        return !this.buffer.isEmpty();
    }

    public synchronized Collection<LogRecord> getRecords() {
        return Collections.unmodifiableCollection(this.buffer);
    }

    public Session start() {
        return new Session();
    }

    @Override
    public synchronized void publish(@Nullable LogRecord record) {
        if (record != null && record.getLevel().intValue() >= this.level.intValue() && (this.threadIds.isEmpty() || this.threadIds.contains((long)record.getThreadID() & 0xFFFFFFFFL)) && this.buffer.size() < BUFFER_LIMIT) {
            this.buffer.addLast(record);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.buffer.clear();
    }

    public class Session
    implements AutoCloseable {
        private final Collection<Logger> loggers = new ArrayList<Logger>();

        Session() {
        }

        public Session includePackage(Package pkg) {
            return this.includeLogger(Logger.getLogger(pkg.getName()));
        }

        public Session includeLog(Log log) {
            return this.includeLogger(log.getLogger());
        }

        public synchronized Session includeLogger(Logger logger) {
            this.loggers.add(logger);
            logger.addHandler(LogMonitor.this);
            return this;
        }

        @Override
        public void close() {
            for (Logger logger : this.loggers) {
                logger.removeHandler(LogMonitor.this);
            }
            this.loggers.clear();
        }
    }
}

