/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.check.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogLineFormatter
extends Formatter {
    private static final int STRING_BUFFER_SIZE = 2048;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss,SSS");

    @Override
    public String format(@Nullable LogRecord record) {
        String message = null;
        if (record != null) {
            try (StringWriter sw = new StringWriter(2048);
                 PrintWriter pw = new PrintWriter(sw);){
                pw.print(DATE_FORMAT.format(new Date(record.getMillis())));
                pw.print(" [");
                pw.print(record.getThreadID());
                pw.print("] ");
                pw.print(record.getLevel());
                pw.print(" ");
                pw.print(record.getLoggerName());
                pw.print(": ");
                pw.println(this.formatMessage(record));
                Throwable thrown = record.getThrown();
                if (thrown != null) {
                    thrown.printStackTrace(pw);
                }
                pw.flush();
                message = sw.toString();
            }
            catch (Exception e) {
                System.err.println("An error occurred during log message formatting");
                e.printStackTrace();
            }
        }
        return message != null ? message : "...";
    }
}

