/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.check.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Function;

public final class Strings {
    private Strings() {
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.length() == 0;
    }

    public static boolean notEmpty(@Nullable String s) {
        return s != null && s.length() > 0;
    }

    public static String safe(@Nullable String s) {
        return s != null ? s : "";
    }

    @Nullable
    public static String safeTrim(@Nullable String s) {
        return s != null ? s.trim() : s;
    }

    public static String[] split(String s, String delimiter) {
        ArrayList<String> split = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(s, delimiter);
        StringBuilder tokenBuffer = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (tokenBuffer.length() > 0) {
                split.add(tokenBuffer.toString());
                tokenBuffer.setLength(0);
            }
            tokenBuffer.append(token);
        }
        if (tokenBuffer.length() > 0) {
            split.add(tokenBuffer.toString());
        }
        return split.toArray(new String[split.size()]);
    }

    public static <T> String join(Iterable<T> objects, String delimiter) {
        return Strings.join(objects, Objects::toString, delimiter, Integer.MAX_VALUE);
    }

    public static <T> String join(Iterable<T> objects, String delimiter, int limit) {
        return Strings.join(objects, Objects::toString, delimiter, limit);
    }

    public static <T> String join(Iterable<T> objects, Function<T, String> converter, String delimiter, int limit) {
        StringBuilder buffer = new StringBuilder();
        for (T object : objects) {
            int bufferLength = buffer.length();
            if (bufferLength > 0) {
                buffer.append(delimiter);
            }
            if (bufferLength >= limit) {
                buffer.append("\u2026");
                break;
            }
            buffer.append(converter.apply(object));
        }
        return buffer.toString();
    }
}

