/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.check.Nullable;
import de.carne.util.Exceptions;
import de.carne.util.logging.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PropertiesHelper {
    private static final Log LOG = new Log();

    private PropertiesHelper() {
    }

    public static Properties init(Class<?> cls) {
        Properties properties;
        try {
            properties = PropertiesHelper.load(cls);
        }
        catch (IOException e) {
            throw Exceptions.toRuntime(e);
        }
        return properties;
    }

    public static Properties load(Class<?> cls) throws IOException {
        Properties properties;
        try (InputStream stream = cls.getResourceAsStream(cls.getSimpleName() + ".properties");){
            if (stream == null) {
                throw new FileNotFoundException("Resource not found for class: " + cls.getName());
            }
            properties = new Properties();
            properties.load(stream);
        }
        return properties;
    }

    @Nullable
    public static String get(Class<?> cls, String key, @Nullable String def) {
        return System.getProperty(PropertiesHelper.systemPropertyKey(cls, key), def);
    }

    public static int getInt(Class<?> cls, String key, int def) {
        return PropertiesHelper.getInt(System.getProperties(), PropertiesHelper.systemPropertyKey(cls, key), def);
    }

    @Nullable
    public static String get(Properties properties, String key, String def) {
        return properties.getProperty(key, def);
    }

    public static int getInt(Properties properties, String key, int def) {
        return PropertiesHelper.toInt(properties.getProperty(key), key, def);
    }

    private static String systemPropertyKey(Class<?> cls, String key) {
        return cls.getPackage().getName() + key;
    }

    private static int toInt(@Nullable String property, String key, int def) {
        int propertyValue = def;
        if (property != null) {
            try {
                propertyValue = Integer.decode(property);
            }
            catch (NumberFormatException e) {
                LOG.warning(e, "Invalid integer property value ''{0}''=''{1}''; using default value", key, property);
            }
        }
        return propertyValue;
    }
}

