/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradleplugins.java;

import de.carne.gradleplugins.java.GenI18NTask;
import de.carne.gradleplugins.java.JavaToolsExtension;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.api.tasks.SourceSet;

public class JavaToolsPlugin
implements Plugin<Project> {
    public static final String JAVA_TOOL_PLUGIN_NAME = JavaToolsPlugin.class.getPackage().getName();

    public void apply(Project project) {
        this.checkPrerequisites(project);
        project.getExtensions().create("javatools", JavaToolsExtension.class, new Object[0]);
        GenI18NTask genI18NTask = (GenI18NTask)project.getTasks().create("genI18N", GenI18NTask.class);
        genI18NTask.setDescription("Generate I18N resource string classes");
        this.initTaskDependsOn(project, "compileJava", new Object[]{genI18NTask});
        project.afterEvaluate((Action)new AfterEvaluateAction(genI18NTask));
    }

    private void checkPrerequisites(Project project) {
        try {
            project.getPlugins().getPlugin("java");
        }
        catch (UnknownPluginException e) {
            String message = "Unable to apply plugin " + JAVA_TOOL_PLUGIN_NAME + "; please apply java plugin first";
            project.getLogger().error(message);
            throw new GradleException(message, (Throwable)e);
        }
    }

    private void initTaskDependsOn(Project project, String name, Object ... dependencies) {
        Set taskSet = project.getTasksByName(name, false);
        for (Task task : taskSet) {
            task.dependsOn(dependencies);
        }
    }

    public static SourceSet getSourceSet(Project project, String name) {
        return (SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName(name);
    }

    private class AfterEvaluateAction
    implements Action<Project> {
        private GenI18NTask genI18NTask;

        AfterEvaluateAction(GenI18NTask genI18NTask) {
            this.genI18NTask = genI18NTask;
        }

        public void execute(Project project) {
            JavaToolsExtension extension = JavaToolsExtension.get(project);
            extension.log(project.getLogger());
            this.genI18NTask.prepareAfterEvaluate();
        }
    }
}

