/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradleplugins.generate;

import de.carne.gradleplugins.generate.JavaGenerator;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class JavaI18NGenerator
extends JavaGenerator {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(JavaI18NGenerator.class.getName());
    private static final MessageFormat TEMPLATE_I18NCLASS_BEGIN = new MessageFormat(BUNDLE.getString("TEMPLATE_I18NCLASS_BEGIN"));
    private static final MessageFormat TEMPLATE_I18NCLASS_ENTRY = new MessageFormat(BUNDLE.getString("TEMPLATE_I18NCLASS_ENTRY"));
    private static final MessageFormat TEMPLATE_I18NCLASS_END = new MessageFormat(BUNDLE.getString("TEMPLATE_I18NCLASS_END"));
    private static final String FILE_TITLE = "I18N resource strings";
    public static final String KEY_I18N_PACKAGE = "I18N_PACKAGE";
    public static final String KEY_I18N_CLASS = "I18N_CLASS";
    public static final String KEY_I18N_KEY_FILTER = "I18N_KEY_FILTER";

    public JavaI18NGenerator(Date generationTimestamp, DateFormat generationTimestampFormat) {
        super(generationTimestamp, generationTimestampFormat);
    }

    @Override
    public void generate(Map<String, String> ctx, Reader in, Writer out) throws IOException {
        String i18nPackage = this.getContextString(ctx, KEY_I18N_PACKAGE);
        String i18nClass = this.getContextString(ctx, KEY_I18N_CLASS);
        Pattern i18nKeyFilter = Pattern.compile(this.getContextString(ctx, KEY_I18N_KEY_FILTER));
        Properties i18nBundle = new Properties();
        i18nBundle.load(in);
        this.generateFileComment(out, this.formatGenerationTimestamp(), FILE_TITLE);
        this.write(out, TEMPLATE_I18NCLASS_BEGIN, i18nPackage, i18nClass);
        for (Map.Entry<Object, Object> entry : i18nBundle.entrySet()) {
            String i18nKey = entry.getKey().toString();
            if (!i18nKeyFilter.matcher(i18nKey).matches()) continue;
            String i18nValue = entry.getValue().toString();
            this.write(out, TEMPLATE_I18NCLASS_ENTRY, i18nKey, this.encodeComment(i18nValue));
        }
        this.write(out, TEMPLATE_I18NCLASS_END, new Object[0]);
    }
}

