/*
 * Decompiled with CFR 0.152.
 */
package de.carne.gradleplugins.generate;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;

public abstract class Generator {
    private Date generationTimestamp;
    private DateFormat generationTimestampFormat;

    protected Generator(Date generationTimestamp, DateFormat generationTimestampFormat) {
        this.generationTimestamp = generationTimestamp != null ? generationTimestamp : new Date();
        this.generationTimestampFormat = generationTimestampFormat != null ? generationTimestampFormat : DateFormat.getDateTimeInstance();
    }

    public Date getGenerationTimestamp() {
        return this.generationTimestamp;
    }

    public DateFormat getGenerationTimestampFormat() {
        return this.generationTimestampFormat;
    }

    public String formatGenerationTimestamp() {
        return this.generationTimestampFormat.format(this.generationTimestamp);
    }

    public abstract void generate(Map<String, String> var1, Reader var2, Writer var3) throws IOException;

    protected String getContextString(Map<String, String> ctx, String key) {
        String value = ctx.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Undefined context paramter: " + key);
        }
        return value;
    }

    protected String getContextString(Map<String, String> ctx, String key, String defaultValue) {
        return ctx.getOrDefault(key, defaultValue);
    }

    protected void write(Writer out, MessageFormat template, Object ... arguments) throws IOException {
        String outData = template.format(arguments);
        out.write(outData);
    }
}

