/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance();

    @Override
    public String format(LogRecord record) {
        String message = null;
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            StringBuffer sb = sw.getBuffer();
            sb.ensureCapacity(sb.length() + 2048);
            sb.append(this.dateFormat.format(new Date(record.getMillis())));
            sb.append(" [");
            sb.append(record.getThreadID());
            sb.append("] ");
            sb.append(Log.levelToString(record.getLevel()));
            sb.append(' ');
            sb.append(record.getLoggerName());
            sb.append(' ');
            sb.append(this.formatMessage(record));
            pw.println();
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                thrown.printStackTrace(pw);
            }
            pw.flush();
            message = sw.toString();
        }
        catch (Exception e) {
            System.err.println("An exception occured while formatting a log message");
            e.printStackTrace();
        }
        return message;
    }
}

