/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.LogManager;

public final class LogConfig {
    private static final String THIS_PACKAGE = LogConfig.class.getPackage().getName();
    private static String currentConfig = null;
    private static long currentConfigNanos = 0L;
    public static final String CONFIG_DEFAULT = "logging-default.properties";
    public static final String CONFIG_VERBOSE = "logging-verbose.properties";
    public static final String CONFIG_DEBUG = "logging-debug.properties";

    public LogConfig() {
        LogConfig.applyConfig(System.getProperty(THIS_PACKAGE, CONFIG_DEFAULT));
    }

    public static synchronized boolean applyConfig(String config) {
        Throwable throwable;
        InputStream configIS2;
        boolean configApplied;
        assert (config != null);
        boolean bl = configApplied = currentConfig != null;
        if (currentConfig != null && !currentConfig.equals(config)) {
            LogManager.getLogManager().reset();
            configApplied = false;
        }
        if (!configApplied) {
            try {
                configIS2 = new FileInputStream(config);
                throwable = null;
                try {
                    LogManager.getLogManager().readConfiguration(configIS2);
                    configApplied = true;
                    currentConfig = config;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (configIS2 != null) {
                        if (throwable != null) {
                            try {
                                configIS2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            configIS2.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException configIS2) {
            }
            catch (Exception e) {
                System.err.println("An exception occured while reading the logging configuration file: " + config);
                e.printStackTrace();
            }
        }
        if (!configApplied) {
            try {
                configIS2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(config);
                throwable = null;
                try {
                    if (configIS2 != null) {
                        LogManager.getLogManager().readConfiguration(configIS2);
                        configApplied = true;
                        currentConfig = config;
                        currentConfigNanos = System.nanoTime();
                    } else {
                        System.err.println("Unable to open logging configuration: " + config);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (configIS2 != null) {
                        if (throwable != null) {
                            try {
                                configIS2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            configIS2.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("An exception occured while reading the logging configuration resource: " + config);
                e.printStackTrace();
            }
        }
        return configApplied;
    }

    public static long configTime() {
        return currentConfigNanos;
    }
}

