/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogBufferHandler
extends Handler {
    public static final int BUFFER_SIZE = 1000;
    private ArrayDeque<LogRecord> records = new ArrayDeque(1000);
    private HashSet<Handler> handlers = new HashSet();

    public static LogBufferHandler getHandler(Logger logger) {
        assert (logger != null);
        LogBufferHandler foundHandler = null;
        block0: for (Logger currentLogger = logger; currentLogger != null && foundHandler == null; currentLogger = currentLogger.getParent()) {
            for (Handler handler : currentLogger.getHandlers()) {
                if (!(handler instanceof LogBufferHandler)) continue;
                foundHandler = (LogBufferHandler)handler;
                continue block0;
            }
        }
        return foundHandler;
    }

    public synchronized void addHandler(Handler handler) {
        assert (handler != null);
        for (LogRecord record : this.records) {
            handler.publish(record);
        }
        this.handlers.add(handler);
    }

    public synchronized void removeHandler(Handler handler) {
        assert (handler != null);
        this.handlers.remove(handler);
    }

    @Override
    public void publish(LogRecord record) {
        this.publishRecord(record);
    }

    @Override
    public void flush() {
        this.flushHandlers();
    }

    @Override
    public void close() throws SecurityException {
        this.closeHandlers();
    }

    private synchronized void publishRecord(LogRecord record) {
        while (this.records.size() >= 1000) {
            this.records.removeFirst();
        }
        this.records.addLast(record);
        for (Handler handler : this.handlers) {
            handler.publish(record);
        }
    }

    private synchronized void flushHandlers() {
        for (Handler handler : this.handlers) {
            handler.flush();
        }
        this.records.clear();
    }

    private synchronized void closeHandlers() {
        for (Handler handler : this.handlers) {
            handler.close();
        }
        this.records.clear();
    }
}

