/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util.logging;

import de.carne.util.logging.LogConfig;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    public static final Level LEVEL_NOTICE = Level.OFF;
    public static final Level LEVEL_ERROR = Level.SEVERE;
    public static final Level LEVEL_WARNING = Level.WARNING;
    public static final Level LEVEL_INFO = Level.FINE;
    public static final Level LEVEL_DEBUG = Level.FINER;
    private long loggerConfigTime = LogConfig.configTime();
    private Logger logger;

    public Log(Class<?> clazz) {
        this.logger = Logger.getLogger(clazz.getName());
    }

    public Log(Class<?> clazz, ResourceBundle bundle) {
        this.logger = Logger.getLogger(clazz.getName(), bundle.getBaseBundleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger() {
        long configTime = LogConfig.configTime();
        if (this.loggerConfigTime != configTime) {
            Log log = this;
            synchronized (log) {
                this.loggerConfigTime = configTime;
                this.logger = Logger.getLogger(this.logger.getName(), this.logger.getResourceBundleName());
            }
        }
        return this.logger;
    }

    public boolean isLoggable(Level level) {
        return this.getLogger().isLoggable(level);
    }

    public void log(Level level, Throwable thrown, ResourceBundle bundle, String format, Object ... args) {
        Logger currentLogger = this.getLogger();
        if (currentLogger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, format);
            record.setResourceBundle(bundle);
            record.setParameters(args);
            record.setThrown(thrown);
            record.setLoggerName(currentLogger.getName());
            currentLogger.log(record);
        }
    }

    public void notice(ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_NOTICE, null, bundle, format, args);
    }

    public void notice(Throwable thrown, ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_NOTICE, thrown, bundle, format, args);
    }

    public void error(ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_ERROR, null, bundle, format, args);
    }

    public void error(Throwable thrown, ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_ERROR, thrown, bundle, format, args);
    }

    public void warning(ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_WARNING, null, bundle, format, args);
    }

    public void warning(Throwable thrown, ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_WARNING, thrown, bundle, format, args);
    }

    public boolean isInfoLoggable() {
        return this.isLoggable(LEVEL_INFO);
    }

    public void info(ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_INFO, null, bundle, format, args);
    }

    public void info(Throwable thrown, ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_INFO, thrown, bundle, format, args);
    }

    public boolean isDebugLoggable() {
        return this.isLoggable(LEVEL_DEBUG);
    }

    public void debug(ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_DEBUG, null, bundle, format, args);
    }

    public void debug(Throwable thrown, ResourceBundle bundle, String format, Object ... args) {
        this.log(LEVEL_DEBUG, thrown, bundle, format, args);
    }

    public static String levelToString(Level level) {
        String levelText = LEVEL_NOTICE.equals(level) ? " NOTICE" : (LEVEL_ERROR.equals(level) ? "  ERROR" : (LEVEL_WARNING.equals(level) ? "WARNING" : (LEVEL_INFO.equals(level) ? "   INFO" : (LEVEL_DEBUG.equals(level) ? "  DEBUG" : String.valueOf(level)))));
        return levelText;
    }

    public static Level snapLevel(Level level) {
        Level snappedLevel = level == null ? LEVEL_DEBUG : (LEVEL_NOTICE.intValue() <= level.intValue() ? LEVEL_NOTICE : (LEVEL_ERROR.intValue() <= level.intValue() ? LEVEL_ERROR : (LEVEL_WARNING.intValue() <= level.intValue() ? LEVEL_WARNING : (LEVEL_INFO.intValue() <= level.intValue() ? LEVEL_INFO : LEVEL_DEBUG))));
        return snappedLevel;
    }
}

