/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import de.carne.ApplicationLoader;
import de.carne.util.Exceptions;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public final class Version {
    public static final String PROJECT_ID;
    public static final String PROJECT_NAME;
    public static final String BUILD_VERSION;
    public static final String BUILD_DATE;

    private static String getAttributeValue(Attributes attributes, String name) {
        String value = attributes != null ? attributes.getValue(name) : null;
        return value != null ? value : "?";
    }

    static {
        Attributes attributes = null;
        try (JarFile codeJar = ApplicationLoader.getCodeJar();){
            if (codeJar != null) {
                attributes = codeJar.getManifest().getMainAttributes();
            }
        }
        catch (Exception e) {
            Exceptions.rethrowAsRuntime(e);
        }
        PROJECT_ID = Version.getAttributeValue(attributes, "X-Version-ProjectId");
        PROJECT_NAME = Version.getAttributeValue(attributes, "X-Version-ProjectName");
        BUILD_VERSION = Version.getAttributeValue(attributes, "X-Version-ProjectVersion");
        BUILD_DATE = Version.getAttributeValue(attributes, "X-Version-BuildDate");
    }
}

