/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import java.text.NumberFormat;

public final class Nanos {
    private final long startNanos = System.nanoTime();

    public long elapsed() {
        return System.nanoTime() - this.startNanos;
    }

    public long elapsedMillis() {
        return Nanos.toMillis(System.nanoTime() - this.startNanos);
    }

    public String toString() {
        return Nanos.toString(this.elapsed());
    }

    public static String toString(long nanos) {
        return NumberFormat.getNumberInstance().format(nanos) + " ns";
    }

    public String toMillisString() {
        return Nanos.toMillisString(this.elapsedMillis());
    }

    public static String toMillisString(long millis) {
        return NumberFormat.getNumberInstance().format(millis) + " ms";
    }

    public static long toMillis(long nanos) {
        return nanos / 1000000L;
    }

    public static long toNanos(long millis) {
        return millis * 1000000L;
    }
}

