/*
 * Decompiled with CFR 0.152.
 */
package de.carne.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public final class IOUtils {
    public static long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        assert (in != null);
        assert (out != null);
        long copied = 0L;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
            copied += (long)read;
        }
        return copied;
    }

    public static long copy(Reader in, Writer out) throws IOException {
        int read;
        assert (in != null);
        assert (out != null);
        long copied = 0L;
        char[] buffer = new char[4096];
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
            copied += (long)read;
        }
        return copied;
    }

    public static void deleteDirectory(Path directory) throws IOException {
        assert (directory != null);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

